
from utils import *
from qt import *
from kdefx import *

class PhotoEvents(QObject):
	size = 1
	pixel = 2
	image = 3 # size and pixel
	meta = 4
	all = 7
	
	def __init(self):
		QObject.__init__(self)
		
	def update(self, key, flag=0):
		self.emit(PYSIGNAL("photoUpdate"), (key, flag))

class Photo:
	"""
			photo = {}
			photo['Date'] = mtime
			photo['ImportDate'] = int(time.time())
			photo['Caption'] = filename
			photo['Rating'] = 0
			photo['Comments'] = ""			
			photo['ImagePath'] = proposedPath
			photo['ThumbPath'] = thumbFilename
			photo['AspectRatio'] = w/float(h)
			photo['Width'] = w
			photo['Height'] = h
			photo['Format'] = QImage.imageFormat(proposedPath)
	"""
	updateEvents = PhotoEvents()
	
	def __init__(self, key, dict):
		self.key = key
		self.dict = dict
		self.has_key = self.dict.has_key
		self.setdefault = self.dict.setdefault
		self.get = self.dict.get
		self.__getitem__ = self.dict.__getitem__
		self.__setitem__ = self.dict.__setitem__
		self.image = None
		
	def load(self):
		if self.image == None:
			self.image = QImage(self['ImagePath'])

	def setImage(self, image):
		self.image = image
		
	def save(self):
		if self.isFormatJpeg():
			self.image.save(self['ImagePath'], self['Format'], 100)
		else:
			self.image.save(self['ImagePath'], self['Format'])

	def saveCustom(self, dst, size=QSize(240,180), quality=100, format="JPEG"):
		self.load()
		i = self.image
		if format==None:
			format = self['Format']
		if quality==None:
			quality = 100
		if size==None or size.width()==0 or size.height()==0:
			size = i.size()
			
		if i.width() > i.height() and size.width() < size.height() \
			or i.width() < i.height() and size.width() > size.height():
			size.transpose()
		if i.width() > size.width() or i.height() > size.height():
			ratio = min(size.width()/float(i.width()), size.height()/float(i.height()))
			w = int(i.width()*ratio)
			h = int(i.height()*ratio)
			t = i.smoothScale(w,h)
			t.save(dst, format, quality)
		elif quality == 100 and format == self['Format']:
			LUtils.safeCopy(self['ImagePath'], dst)
		else:
			i.save(dst, format, quality)
		return (i.width(), i.height())
			
	def export(self, dst, size=None, quality=100, format=None):
		if size or quality!=100 or (format!=None and format!=self['Format']):
			if quality != 100 and format == None: # if a quality was specified, save as jpeg
				format = "JPEG"
			self.saveCustom(dst, size, quality, format) 
		else:
			LUtils.safeCopy(self['ImagePath'], dst)
		
	def __refreshThumbnail(self):
		(w,h) = self.saveCustom(self['ThumbPath'])
		self['Width'] = w
		self['Height'] = h
		self['AspectRatio'] = w/float(h)
				
	def hasOriginal(self):
		(dir, filename) = os.path.split(self['ImagePath'])
		return LUtils.fileExists(os.path.join(dir, "originals", filename))

	def isFormatJpeg(self):
		# getPath returns the path to the file to use for Fomat type
		def getPath(self):
			if self.hasOriginal():
				(dir, filename) = os.path.split(self['ImagePath'])
				return os.path.join(dir, "originals", filename)
			else:
				return self['ImagePath']
				
		if (self.has_key('Format')):
			return "JPEG" == self['Format']
		else:
			return "JPEG" == self.setdefault('Format', QImage.imageFormat(getPath(self)))
				
	def __backupImage(self, restore=False):
		ipath = self['ImagePath']
		(dir, filename) = os.path.split(ipath)
		bdir = os.path.join(dir,"originals")
		bpath = os.path.join(bdir,filename)
		if restore:
			if LUtils.fileExists(bpath):
				shutil.move(bpath, ipath)
		else:
			if not(LUtils.fileExists(bpath)):
				LUtils.ensureDirectory(bdir)
				shutil.copy2(ipath, bpath)

	def rotate(self):
		wc = LWaitCursor()
		self.__backupImage()
		if self.isFormatJpeg():
			os.system("jpegtran -copy all -rotate 90 -outfile \"%s\" \"%s\"" % (self['ImagePath'],self['ImagePath']))
			self.image = None
		else:
			self.load()
			m = QWMatrix()
			m.rotate(90.0);
			self.image = self.image.xForm(m);
			self.save()
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.image)

	def rotateReverse(self):
		wc = LWaitCursor()
		self.__backupImage()
		if self.isFormatJpeg():
			os.system("jpegtran -copy all -rotate 270 -outfile \"%s\" \"%s\"" % (self['ImagePath'],self['ImagePath']))
			self.image = None
		else:
			self.load()
			m = QWMatrix()
			m.rotate(-90.0);
			self.image = self.image.xForm(m);
			self.save()
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.image)

	def crop(self, rect):
		wc = LWaitCursor()
		self.__backupImage()
		ipath = self['ImagePath']
		if self.isFormatJpeg():
			os.system("jpegtran -copy all -crop %dx%d+%d+%d -outfile \"%s\" \"%s\"" % (rect.width(),rect.height(),rect.left(),rect.top(),ipath,ipath))
			self.image = None
		else:
			self.load()
			self.image = self.image.copy(rect)
			self.save()
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.image)

	def enhance(self, key):
		wc = LWaitCursor()
		self.__backupImage()
		self.load()
		KImageEffect.normalize(self.image)
		self.save()
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.pixel)

	def grayscale(self):
		wc = LWaitCursor()
		self.__backupImage()
		if self.isFormatJpeg():
			os.system("jpegtran -copy all -grayscale -outfile \"%s\" \"%s\"" % (self['ImagePath'],self['ImagePath']))
			self.image = None
		else:
			self.load()
			self.image = KImageEffect.toGray(self.image)
			self.save()
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.pixel)
	
	def redeye(self, rect):
		wc = LWaitCursor()
		# load rect from file into QImage
		self.__backupImage()
		self.load()
		if self.image:
			i = self.image
			for x in range(rect.left(),rect.right()):
				for y in range(rect.top(),rect.bottom()):
					rgb = i.pixel(x,y)
					r = qRed(rgb)#.0/255.0
					g = qGreen(rgb)#/255.0
					b = qBlue(rgb)#/255.0
					if r:
						redness = (4.0-(4.0*max(g,b))/r)
						if redness < 0:
							redness = 0
						else:
							#redness = redness * redness / 16.0 * 255.0
							if redness > 0.7921:
								r = max(g,b)
								rgb = qRgb(r,g,b)
								i.setPixel(x,y,rgb)
			self.save()
			self.__refreshThumbnail()
			Photo.updateEvents.update(self.key, PhotoEvents.pixel)
			
	def revert(self):
		wc = LWaitCursor()
		self.__backupImage(True)
		self.__refreshThumbnail()
		Photo.updateEvents.update(self.key, PhotoEvents.image)
		
	def getFilename(self, useTitle = False, count=None):
		# useTitle, use the photo Caption instead of the actual filename
		# count, int used to make a unique filename when filenames collide
		if useTitle:
			title = self['Caption']
		else:
			title = os.path.split(self['ImagePath'])[1]
			
		# check for extension (.jpg or .jpeg or .format)
		(a,b) = os.path.splitext(title)		
		blow = b.lower()
		if self.isFormatJpeg():
			if b == None or len(b) == 0 \
				or (blow != ".jpg" and blow != ".jpeg"):
				b = ".jpg"
		else:
			if b == None or len(b) == 0 or blow != "."+self['Format'].lower():
				b = self['Format'].lower()
		if count:
			return a+str(count)+b
		else:
			return a+b
			
	def getFileSize(self):
		return os.stat(self['ImagePath'])[6]
		
	def dateSwap(self):
		self['Date'], self['ImportDate'] =  self['ImportDate'], self['Date']
		Photo.updateEvents.update(self.key, PhotoEvents.meta)
		
		
if __name__ == "__main__":
	import time
	
	photo = {}
	photo['Date'] = int(time.time())
	photo['ImportDate'] = int(time.time())
	photo['Caption'] = "\root\docs\My Photos\LphotoExample1.jpg"
	photo['Rating'] = 0
	photo['Comments'] = ""			
	photo['ImagePath'] = "\root\docs\My Photos\LphotoExample1.jpg"
	photo['ThumbPath'] = "\root\docs\My Photos\LphotoExample1-thumb.jpg"
	photo['AspectRatio'] = 1 #w/float(h)
	photo['Width'] = 100 # w	
	photo['Height'] = 100 # h 
	photo['Format'] = QImage.imageFormat("\root\docs\My Photos\LphotoExample1.jpg")
	
	p = Photo("1", photo)
	photo['Caption'] = "Testing"
	
	p.load()
	print p['Caption']
	
	
	
	
