from kdeemul import *
from kdefx import *

from qt import *
from utils import *

from photo import *

import math

class LZoomView(QWidget):
	def __init__(self, parent):
		QWidget.__init__(self, parent)
		self.setBackgroundMode(Qt.NoBackground)
		self.zoom = 1.0
		self.scale = 1.0
		self.path = None
		self.osvRect = QRect(0,0,0,0)
		self.zoomPointImage = QPoint(0,0)
		self.zoomPointScreen = QPoint(0,0)
		self.selRect = None
		self.selAnchor = None
		self.image = None
		self.scaledImage = None
		self.whiteImage = None
		self.dragStart = None
		self.selAnchor = None
		self.origWhiteImage = None
		#QObject.connect(self, SIGNAL("contentsMoving(int, int)"), self.slotContentsMoving)

	def setImagePath(self, path, key):
		self.image = None
		self.scaledImage = None
		self.whiteImage = None
		self.selRect = None
		self.origWhiteImage = None
		self.slider.setValue(self.slider.minValue())
		self.path = path
		self.key = key
		self.update()

	def updateScale(self):
		# osRect = offscreen rect, image size * scale
		# osvRect = offscreen viewport rect topLeft = (0,0) of view
		# izRect = viewport rect in image coordinates
		# zoomPointImage = zoom point in image coordinates
		# zoomPointScreen = zoom point in screen coordinates
		# zoomPointOS = zoom point in offscreen coordinates
			
		self.scaledImage = None
		self.whiteImage = None
		rs = self.rect()
		if not self.image:
			return
		ri  = self.image.rect()
		if (ri.width() == 0) or (ri.height() ==0):
			self.scale = 1.0
		elif ri.width() < rs.width() and ri.height() < rs.height():
			self.scale = self.zoom
		else:
			self.scale = min(rs.width()/float(ri.width()), rs.height()/float(ri.height())) * self.zoom
		
		# set offscreen image size
		self.osRect = QRect(0, 0 ,ri.width()*self.scale,ri.height()*self.scale)
		# if we don't have a center point yet, set it to the middle of the image
		zoomPointOS = QPoint(self.zoomPointImage.x()*self.scale,self.zoomPointImage.y()*self.scale)
		# set offscreenviewport rect
		self.osvRect = rs
		self.osvRect = LUtils.alignRectToPoint(self.zoomPointScreen, self.osvRect, zoomPointOS, self.osRect)
		#self.osvRect = LUtils.centerRect(self.osvRect, centerOS, self.osRect)
		# set src image rect
		self.izRect = QRect(self.osvRect.x()/self.scale,self.osvRect.y()/self.scale,self.osvRect.width()/self.scale,self.osvRect.height()/self.scale)
		self.emit(PYSIGNAL("updateScale()"), (None, None))
		self.sliderLabel.setText("%d%%"%(int(math.floor(self.scale*10))*10))

	def buildHQImage(self):
		cropped = self.image.copy(self.izRect)
		return cropped.smoothScale(self.osvRect.size())

	def buildScaledImage(self):
		cropped = self.image.copy(self.izRect)
		return cropped.scale(self.osvRect.size())
		
	def buildWhiteImage(self):
		if (self.origWhiteImage == None):
			self.origWhiteImage = self.image.copy()
			KImageEffect.blend(QColor(Qt.white), self.origWhiteImage, 0.5)
		cropped = self.origWhiteImage.copy(self.izRect)
		return cropped.scale(self.osvRect.size())
		return self.scaledImage
##~ 		i = self.scaledImage.copy()
##~ 		KImageEffect.blend(QColor(Qt.white), i, 0.5)
##~ 		return i

	def drawHQ(self):
		p = QPainter(self)
		self.scaledImage = self.buildHQImage()
		p.drawImage(0, 0, self.scaledImage)
##~ 		pio = KPixmapIO()
##~ 		pm = pio.convertToPixmap(self.scaledImage)
##~ 		bitBlt(self, 0, 0, pm, 0,0,pm.width(),pm.height())
		if self.selRect:
			p.drawRect(self.rectImageToScreen(self.selRect))
			
	def paintSelection(self, p):
		r = self.rect()
		ri = r.intersect(self.rectImageToScreen(self.image.rect()))
		rs = ri.intersect(self.rectImageToScreen(self.selRect))
		(r1,r2,r3,r4) = LUtils.getBoundingRects(ri, rs)
		
		if r1.isValid():
			p.drawImage(r1.topLeft(), self.whiteImage, r1)
		if r2.isValid():
			p.drawImage(r2.topLeft(), self.whiteImage, r2)
		if r3.isValid():
			p.drawImage(r3.topLeft(), self.whiteImage, r3)
		if r4.isValid():
			p.drawImage(r4.topLeft(), self.whiteImage, r4)
		
		if rs.isValid():
			p.drawImage(rs.topLeft(), self.scaledImage, rs)
			p.drawRect(rs)
		
		if ri != r:
			(r1,r2,r3,r4) = LUtils.getBoundingRects(r, ri)
			if r1.isValid():
				p.drawImage(r1.topLeft(), self.scaledImage, r1)
			if r2.isValid():
				p.drawImage(r2.topLeft(), self.scaledImage, r2)
			if r3.isValid():
				p.drawImage(r3.topLeft(), self.scaledImage, r3)
			if r4.isValid():
				p.drawImage(r4.topLeft(), self.scaledImage, r4)

	def paintEvent(self, paintEvent):
		if not self.path:
			return

		if not self.image:
			self.image = QImage(self.path)
			self.zoomPointImage = self.image.rect().center()
			self.zoomPointScreen = self.rect().center()
			self.updateScale()
		if not self.scaledImage:
			self.scaledImage = self.buildScaledImage()
		if self.selRect and not(self.whiteImage):
			self.whiteImage = self.buildWhiteImage()
		if self.selRect:
			p = QPainter(self)
			self.paintSelection(p)
			
##~ 			p.drawPixmap(0,0,self.os)			
			
##~ 			p.drawImage(0,0,self.scaledImage)
##~ 			r = self.rect()
##~ 			ri = r.intersect(self.rectImageToScreen(self.image.rect()))
##~ 			rs = ri.intersect(self.rectImageToScreen(self.selRect))
##~ 			p.drawRect(rs)
##~ 		else:
##~ 			p.drawImage(0,0,self.scaledImage)
		else:
			pio = KPixmapIO()
			pm = pio.convertToPixmap(self.scaledImage)
			bitBlt(self, 0, 0, pm, 0,0,pm.width(),pm.height())

	def resizeEvent(self, resizeEvent):
##~ 		self.zoomPointScreen = self.rect().center()
##~ 		self.zoomPointImage = self.screenToImage(self.zoomPointScreen)
		self.updateScale()

	def moveViewportY(self, y):
		# scroll bar move
		# set zoomPointScreen to center
		# set zoomPointImage to new offset from center
		if y != self.osvRect.top():
			print "move y"
			self.zoomPointScreen = self.rect().center()
			zoomPointOS = QPoint(self.osvRect.center().x(), y+(self.osvRect.height()/2))
			self.zoomPointImage = self.offscreenToImage(zoomPointOS)
			self.updateScale()
			self.update()

	def moveViewportX(self,x):
		if x != self.osvRect.left():
			print "move x",x,self.osvRect.left(),x-self.osvRect.left()
			self.zoomPointScreen = self.rect().center()
			zoomPointOS = QPoint(x+(self.osvRect.width()/2), self.osvRect.center().y())
			self.zoomPointImage = self.offscreenToImage(zoomPointOS)
			self.updateScale()
			self.update()

	def setZoom(self, zoom):
		self.zoom = zoom
		self.updateScale()
		self.update()

	def offscreenViewportRect(self):
		return self.osvRect

	def offscreenRect(self):
		return self.osRect

	def clearCenter(self):
		self.zoomPointScreen = self.rect().center()
		zoomPointOS = self.osvRect.center()
		self.zoomPointImage = self.image.rect().center()

	def offscreenToImage(self, po):
		return QPoint((po.x() / self.scale)+0.5, (po.y() / self.scale)+0.5)
		
	def screenToOffscreen(self, ps):
		return self.osvRect.topLeft() + ps
		
	def screenToImage(self, ps):
		return self.offscreenToImage(self.screenToOffscreen(ps))
		
	def rectImageToScreen(self, ri):
		return QRect((ri.x()-0.5)*self.scale-self.osvRect.left(),(ri.y()-0.5)*self.scale-self.osvRect.top(),ri.width()*self.scale,ri.height()*self.scale)
		
	def centerZoomPoint(self):
		if self.selRect:
			self.zoomPointScreen = self.rect().center()
			self.zoomPointImage = self.selRect.center()
			print "selRect center", self.selRect.center().x(),self.selRect.center().y()
		else:
			self.zoomPointScreen = self.rect().center()
			self.zoomPointImage = self.offscreenToImage(self.osvRect.center())
			

	def wheelEvent(self, we):
		# convert point to image coords
		if (we.delta() < 0):
			self.zoomPointScreen = QPoint(we.x(), we.y())
			self.zoomPointImage = self.screenToImage(self.zoomPointScreen)
			self.slider.addStep()
		elif (we.delta() > 0):
			self.zoomPointScreen = QPoint(we.x(), we.y())
			self.zoomPointImage = self.screenToImage(self.zoomPointScreen)
			self.slider.subtractStep()
		# reset zoom point to center of image
		self.centerZoomPoint()

	def mouseMoveEvent(self, me):
		if me.state() == Qt.LeftButton:
			mp = QPoint(me.x(), me.y())
			# create selection rect
			if not self.selRect and self.dragStart:
				# check for three pixel movement before we start selecting
				delta = mp - self.dragStart
				if delta.manhattanLength() < 3:
					return
			r = QRect(self.selAnchor, self.screenToImage(QPoint(me.x(),me.y())))
			self.selRect = self.image.rect().intersect(r.normalize())
			self.update()
		
	def mousePressEvent(self, me):
		if me.button() == Qt.LeftButton:
			self.dragStart = QPoint(me.x(), me.y())
			self.selAnchor = self.screenToImage(self.dragStart)
			if self.selRect:
				self.selRect = None
				self.update()
			
	def mouseReleaseEvent(self, me):
		print "release",me.button()
##~ 		if me.button() == Qt.LeftButton and self.selRect:
##~ 			self.selRect = None
##~ 			self.update()

	def slotUpdateImage(self, key, hint):
		if key == self.key and hint & PhotoEvents.pixel:
			#reload image
			if hint & PhotoEvents.size: #optimization: only reload image when pixel but not size event occurs
				self.image = None		#this saves us reloading the image if revert or rotate is done from another view
				self.slider.setValue(self.slider.minValue()) # reset zoom
			else:
				self.image = QImage(self.path)
			self.scaledImage = None
			self.whiteImage = None
			self.origWhiteImage = None
			self.selRect = None
			self.update()

class LEditView(QWidget):
	def __init__(self, parent):
		QWidget.__init__(self, parent)
		gl = QGridLayout(self, 2, 2)
		self.zoomView = LZoomView(self)
		self.zoomView.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
		gl.addWidget(self.zoomView,0,0)
		self.vertScrollBar = QScrollBar(QScrollBar.Vertical, self)
		gl.addWidget(self.vertScrollBar,0,1)
		self.horzScrollBar = QScrollBar(QScrollBar.Horizontal, self)
		gl.addWidget(self.horzScrollBar,1,0)
		self.hValue = 0
		self.vValue = 0
		QObject.connect(self.zoomView, PYSIGNAL("updateScale()"), self.slotUpdateScale)
		QObject.connect(self.vertScrollBar, SIGNAL("valueChanged(int)"), self.slotVertChanged)
		QObject.connect(self.vertScrollBar, SIGNAL("sliderReleased()"), self.slotEndZoom)
		QObject.connect(self.horzScrollBar, SIGNAL("valueChanged(int)"), self.slotHorzChanged)
		QObject.connect(self.horzScrollBar, SIGNAL("sliderReleased()"), self.slotEndZoom)
		QObject.connect(Photo.updateEvents, PYSIGNAL("photoUpdate"), self.zoomView.slotUpdateImage)

	def setLibrary(self, lib):
		self.lib = lib

	def setImageKey(self, key):
		assert(hasattr(self, "lib"))
		if not(hasattr(self, "key")) or self.key != key:
			self.key = key
			self.imageDict = self.lib.getImage(key)
			if self.imageDict:
				self.zoomView.setImagePath(self.imageDict['ImagePath'], key)

	def slotZoomChanged(self, zoom):
		self.zoom = zoom/10.0
		self.zoomView.setZoom(self.zoom)

	def slotSetItem(self, key):
		if key:
			self.setImageKey(key)

	def slotUpdateScale(self):
		rv = self.zoomView.offscreenViewportRect()
		ro = self.zoomView.offscreenRect()

		hMax = ro.width() - rv.width() - 1
		if (hMax <=0):
			self.horzScrollBar.setEnabled(False)
			self.horzScrollBar.setMinValue(self.horzScrollBar.value())
			self.horzScrollBar.setMaxValue(self.horzScrollBar.value())
		else:
			self.horzScrollBar.setMinValue(0)
			self.hValue = min(rv.left(), hMax)
			if self.horzScrollBar.maxValue() < self.hValue:
				self.horzScrollBar.setMaxValue(hMax)
				self.horzScrollBar.setValue(self.hValue)
			else:
				self.horzScrollBar.setValue(self.hValue)
				self.horzScrollBar.setMaxValue(hMax)
			self.horzScrollBar.setMaxValue(hMax)
			self.horzScrollBar.setPageStep(rv.width())
			self.horzScrollBar.setLineStep(10)
			self.horzScrollBar.setEnabled(True)

		vMax = ro.height() - rv.height() - 1
		if (vMax <=0):
			self.vertScrollBar.setEnabled(False)
			self.vertScrollBar.setMinValue(self.vertScrollBar.value())
			self.vertScrollBar.setMaxValue(self.vertScrollBar.value())
		else:
			self.vertScrollBar.setMinValue(0)
			self.vValue = min(rv.top(), vMax)
			if self.vertScrollBar.maxValue() < self.vValue:
				self.vertScrollBar.setMaxValue(ro.height()-rv.height()-1)
				self.vertScrollBar.setValue(rv.top())
			else:
				self.vertScrollBar.setValue(rv.top())
				self.vertScrollBar.setMaxValue(ro.height()-rv.height()-1)
			self.vertScrollBar.setPageStep(rv.height())
			self.vertScrollBar.setLineStep(10)
			self.vertScrollBar.setEnabled(True)

		if self.horzScrollBar.isEnabled() or self.vertScrollBar.isEnabled():
			self.vertScrollBar.show()
			self.horzScrollBar.show()
		else:
			self.vertScrollBar.hide()
			self.horzScrollBar.hide()

	def slotVertChanged(self, value):
		if value != self.vValue:
			self.zoomView.moveViewportY(value)
			self.vValue = value

	def slotHorzChanged(self, value):
		if value != self.hValue:
			self.zoomView.moveViewportX(value)
			self.hValue = value

	def slotEndZoom(self):
		print "end zoom, draw high quality! zoom=",self.zoom
		if self.zoom == 1.0:
			self.zoomView.clearCenter()
		self.zoomView.drawHQ()
			
	def setSlider(self, slider):
		self.zoomView.slider = slider
		
	def setSliderLabel(self, label):
		self.zoomView.sliderLabel = label
		
	def slotCrop(self):
		print "crop"
		if self.zoomView.selRect:
			self.lib.cropImage(self.key, self.zoomView.selRect)
		
	def slotRedeye(self):
		print "red eye"
		if self.zoomView.selRect:
			self.lib.redeyeImage(self.key, self.zoomView.selRect)
		
	def slotBandw(self):
		print "black and white"
		self.lib.greyScaleImage(self.key)
		
	def slotRevert(self):
		self.lib.revertImage(self.key)
		
	def slotEnhance(self):
		self.lib.enhanceImage(self.key)
		
	def desaturateButton(self):
		self.lib.desaturateButton(self.key)
	def normalizeButton(self):
		self.lib.normalizeButton(self.key)
	def equalizeButton(self):
		self.lib.equalizeButton(self.key)
	def constrastHSVButton(self):
		self.lib.constrastHSVButton(self.key)
		
		
