# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the NZBQueue module."""

from lottanzb.hellalog import LogRecord, _FatalErrorHandler, _ExceptionHandler
from lottanzb.util import _

class ReadingZipError(_ExceptionHandler, LogRecord): # nzbZipSearch(...)
    PATTERN = r'^Error reading ZipFile: "(?P<zip_file>.+)"'
    TEMPLATE = _("Error reading ZIP file %(zip_file)s")

class SearchingZipInfo(LogRecord): # nzbZipSearch(...)
    PATTERN = r"^Searching (?P<file>.+) for NZBs\.\.\.$"
    TEMPLATE = _("Searching %(file)s for NZB...")

class SearchingFileInfo(LogRecord): # nzbGzipSearch(...)
    PATTERN = r"^Searching (?P<file>.+) for an NZB\.\.\.$"
    TEMPLATE = _("Searching %(file)s for an NZB...")

class ReadingGZipError(LogRecord): # nzbGzipSearch(...)
    PATTERN = r'^Error reading GzipFile: "(?P<gzip_file>.+)"$'
    TEMPLATE = _("Error reading GZIP file: %(gzip_file)s")

class NoSpaceLeftError(LogRecord): # writeStateXML()
    PATTERN = r"^Unable to write STATE_XML_FILE: No space left on device$"
    TEMPLATE = _("Unable to write STATE_XML_FILE: No space left on device")

class DownloadingInfo(LogRecord): # parseNZB(...)
    PATTERN = r"^Downloading: (?P<archive_name>.+)$"
    TEMPLATE = _("Downloading: %(archive_name)s")

class DownloadingParsInfo(LogRecord): # parseNZB(...)
    PATTERN = r"^Downloading recovery pars: (?P<archive_name>.+)$"
    TEMPLATE = _("Downloading recovery PARs: %(archive_name)s")

class ResumingParDownloadInfo(LogRecord): # parseNZB(...)
    PATTERN = r"^Resuming par recovery download: (?P<archive_name>.+)$"
    TEMPLATE = _("Resuming PAR recovery download: %(archive_name)s")

class ResumingInfo(LogRecord): # parseNZB(...)
    PATTERN = r"^Resuming: (?P<archive_name>.+)$"
    TEMPLATE = _("Resuming: %(archive_name)s")

class ParsingInfo(LogRecord): # parseNZB(...)
    PATTERN = r"^Parsing: (?P<archive_name>.+)\.\.\.$"
    TEMPLATE = _("Parsing: %(archive_name)s...")

class ParsingError(_FatalErrorHandler, LogRecord): # parseNZB(...)
    PATTERN = r"^Problem while parsing the NZB"
    TEMPLATE = _("Problem while parsing the NZB")

class MovingToTempDirError(LogRecord): # parseNZB(...)
    PATTERN = r"^Moving bad NZB out of queue into TEMP_DIR: (?P<temp_dir>.+)$"
    TEMPLATE = _("Moving bad NZB out of queue into TEMP_DIR: %(temp_dir)s")

class PostponedLoadedInfo(LogRecord): # findAndLoadPostponedDir(...)
    PATTERN = r"^Loaded postponed directory: (?P<archive_name>.+)$"
    TEMPLATE = _("Loaded postponed directory: %(archive_name)s")

class DequeueingInfo(LogRecord): # dequeueNZBs(...)
    PATTERN = r"^Dequeueing: (?P<archive_name>.+)$"
    TEMPLATE = _("Dequeueing: %(archive_name)s")

class DequeueingWarning(DequeueingInfo): # dequeueNZBs(...)
    PATTERN = r"^Dequeueing: (?P<archive_name>.+) \(warning: archive has a postponed dir\)$"
    TEMPLATE = _("Dequeueing: %(archive_name)s (Warning: The archive has a postponed directory)")

class TempDirAccessError(LogRecord): # enqueueNZBData(...)
    PATTERN = r"^Unable to write NZB to temp location: (?P<temp_dir>.+)$"
    TEMPLATE = _("Unable to write NZB to the temporary location: %(temp_dir)s")

class ExistingNZBFileError(LogRecord): # enqueueNZBs(...)
    PATTERN = r"^Unable to add nzb file to queue: (?P<nzb_file>.+) it already exists!$"
    TEMPLATE = _("Unable to add NZB file to the queue: %(nzb_file)s (It already exists!)")

class NewNZBFoundInfo(LogRecord): # enqueueNZBs(...)
    PATTERN = r"^Found new nzb( \((msgid: (?P<id>\d+))?(, )?(category: (?P<category>.+))?\))?: (?P<nzb_file>.+)$"
    TEMPLATE = _("Found new NZB %(details)s: %(nzb_file)s")
    
    def set_data(self, data):
        details = []
        
        if data["id"]:
            details.append(_("Newzbin ID: %s") % data["id"])
        
        if data["category"]:
            details.append(_("Category: %s") % data["category"])
        
        data["details"] = ", ".join(details)
        
        LogRecord.set_data(self, data)

class ExistingNZBFileError(LogRecord): # enqueueNZBs(...)
    PATTERN = r"^Unable to move invalid NZB (?P<nzb_file>.+) out of the way$"
    TEMPLATE = _("Unable to move invalid NZB %(nzb_file)s out of the way")
