# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the NZBDownloader module."""

from lottanzb.hellalog import LogRecord
from lottanzb.util import _

class DownloadingInfo(LogRecord): # NZBDownloader.download()
    PATTERN = r"^Downloading from (?P<url>.+)\.\.$"
    TEMPLATE = _("Downloading from %(url)s...")

class NotFoundDownloadError(LogRecord): # NZBDownloader.handleEnqueueNZB()
    PATTERN = r"^Unable to download: (?P<url>.+), no filename found$"
    TEMPLATE = _("Unable to download %(url)s: No filename found")

class TimeoutError(LogRecord): # NZBDownloader.errBack()
    PATTERN = r"^Unable to connect to (?P<url>.+): Connection timed out$"
    TEMPLATE = _("Unable to connect to %(url)s: Connection timed out")

class ConnectionRefusedError(LogRecord): # NZBDownloader.errBack()
    PATTERN = r"^Unable to connect to (?P<url>.+): Connection refused$"
    TEMPLATE = _("Unable to connect to %(url)s: Connection refused")

class DNSLookupError(LogRecord): # NZBDownloader.errBack()
    PATTERN = r"^Unable to connect to (?P<url>.+): DNS lookup failed$"
    TEMPLATE = _("Unable to connect to %(url)s: DNS lookup failed")

class OtherDownloadError(LogRecord): # NZBDownloader.errBack()
    PATTERN = r"^Unable to download from (?P<url>.+): (?P<error_message>.*)$"
    TEMPLATE = _("Unable to download from %(url)s: %(error_message)s")
