/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef CONNECTION_H_
#define CONNECTION_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "lopster.h"

typedef void (*call_func_t)( void* , unsigned long);

void resolve_address(char *address, call_func_t func, 
		    void* data);

void connect_fail(socket_t * socket, char *text);
void connect_progress(char *text);
void connect_success();

socket_t *socket_new(int type);
void socket_destroy(socket_t * socket, int data);
void socket_end(socket_t * socket, int data);
char *socket_get_name(socket_t * socket);

int command_send(net_t* net, gint16 type, ...);
int command_send_unimportant(net_t* net, gint16 type, ...);

void create_upload_port(gint16 port, int send);
int connect_socket(socket_t * s, char *proto, int type);

void socket_update_clist(socket_t * socket);
void socket_show_clist(socket_t * socket);
void socket_remove_clist(socket_t * socket);

int send_safe(int fd, const char* buf, int min, int max);
int recv_safe(int fd, char* buf, int min, int max);

#endif
