/* Copyright (C) 2002 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gtk/gtk.h>
#include <string.h>

#include "support.h"
#include "lopster.h"
#include "global.h"
#include "utils.h"
#include "chat.h"

void ban_networks_clear() {
  GList* dlist;

  for (dlist = global.bannet; dlist; dlist = dlist->next) {
    l_free(dlist->data);
  }
  g_list_free(global.bannet);
  global.bannet = NULL;
}

void ban_networks_load() {
  FILE *fd;
  char *fname;
  char *ip_from, *ip_to;
  bannetworks_t* bn;
  char line[2048];

  fname = l_strdup_printf("%s%cbannetworks.list", 
			  global.options.config_dir, DIR_SEP);

  if ((fd = fopen(fname, "r")) == NULL) {
    l_free(fname);
    return;
  }
  l_free(fname);

  ban_networks_clear();

  while (mfgets(line, sizeof(line), fd)) {
    ip_from = arg(line, 0);
    if (!ip_from) continue;
    if (*ip_from == '#') continue;
    ip_to = arg(NULL, 0);
    if (!ip_to) continue;

    bn = l_malloc(sizeof(*bn));
    bn->ip_from = strtoul(ip_from, NULL, 10);
    bn->ip_to   = strtoul(ip_to,   NULL, 10);
    global.bannet = g_list_append(global.bannet, bn);
  }

  fclose(fd);
}

void ban_networks_save() {
  FILE *fd;
  char *fname;
  bannetworks_t* bn;
  GList* dlist;

  fname = l_strdup_printf("%s%cbannetworks.list", 
			  global.options.config_dir, DIR_SEP);

  if ((fd = fopen(fname, "w")) == NULL) {
    l_free(fname);
    return;
  }
  l_free(fname);
  
  for (dlist = global.bannet; dlist; dlist = dlist->next) {
    bn = dlist->data;
    fprintf(fd, "%lu %lu\n", bn->ip_from, bn->ip_to);
  }

  fclose(fd);
}

int ban_networks_scan(const char *ip) {
  unsigned long uip;
  chat_page_t *page;
  bannetworks_t* bn;
  GList* dlist;

  if (!ip) return 0;
  uip = inet_addr(ip);
  if (uip == htonl(INADDR_NONE)) return 0;

  // swap bytes on bigendian machines to get little endian format
  uip = BSWAP32(uip);

  for (dlist = global.bannet; dlist; dlist = dlist->next) {
    bn = dlist->data;
    if (bn->ip_from <= uip && uip <= bn->ip_to) {
      page = chat_page_search(NULL, "BAN", P_OTHER, 3);
      if (!page)
        page = create_other_page(NULL, "BAN", "BAN");

      chat_print_time_stamp(page, M_PUBLIC);
      chat_print_prefix(page, 1);
      chat_print_text(page, M_PUBLIC, "message", "<");
      chat_print_colored(page, M_PUBLIC, "text", "BAN");
      chat_print_text(page, M_PUBLIC, "message", "> ");
      chat_print_colored(page, M_PUBLIC, "text", ip);
      chat_print_text(page, M_PUBLIC, "message", " [");
      chat_print_colored(page, M_PUBLIC, "text", ip);
      chat_print_text(page, M_PUBLIC, "message", "]");
      chat_print_text(page, M_PUBLIC, "text", "\n");
      return 1;
    }
    if (bn->ip_from > uip) return 0;
  }

  return 0;
}

void ban_networks_add(bannetworks_t* ban) {
  bannetworks_t* bn;
  
  bn = l_malloc(sizeof(*bn));
  memcpy(bn, ban, sizeof(*bn));
  global.bannet = g_list_append(global.bannet, bn);
}
