#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Zone.pm,v 1.27 2001/11/19 10:56:54 slhullier Exp $
##******************************************************************************
## Class Zone  abstract
##  Description  : class from which inherit graphical objects
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Zone.pm,v $
#Revision 1.27  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.26  2001/11/16 14:49:55  slhullier
#*** empty log message ***
#
#Revision 1.25  2001/11/16 14:39:38  slhullier
#*** empty log message ***
#
#Revision 1.24  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.23  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.22  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.21  2001/10/24 08:59:47  lsimonneau
#*** empty log message ***
#
#Revision 1.20  2001/10/23 12:19:04  lsimonneau
#Modification for Report support.
#
#Revision 1.19  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.18  2001/08/03 13:07:27  slhullier
#*** empty log message ***
#
#Revision 1.17  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.16  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.15  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.14  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.13  2001/06/26 10:00:12  slhullier
#
#Heritage BarGraph LineGraph
#
#Revision 1.12  2001/06/26 08:58:54  slhullier
#
#BarGraph ok. Avant fusion Graph/BarGraph avec heritage
#
#Revision 1.11  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.10  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.9  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.8  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.7  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.6  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Zone;

use strict;

use LogTrend::Visu::Expression;
use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the Type XML node, the Zone XML node,
##******************************************************************************
sub new
{
   my ($classname,$falserootnode,$rootnode,$systemsDeclaration) = @_;
   my $self = {};
   bless($self, $classname);
   my ($list,$node,$valueref,$sublist,$subnode);

   ##===========================================================================
   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;

   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Title") || die("Zone: No \"Title\" tag.");
   $node = $list->item(0) || die("Zone: No \"Title\" tag.");
   $valueref = $node->getFirstChild() || die("Zone: No \"Title\" tag.");
   $self->{TITLE} = $valueref->getNodeValue();

   $self->{TITLE} = AccentsXML2Text( $self->{TITLE} );

   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Position") ||
                                               die("Zone: No \"Position\" tag.");
   $node = $list->item(0) || die("Zone: No \"Position\" tag.");
   my $attributes = $node->getAttributes() || die("Error in \"Position\" tag.");
   my $attrnode;

   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("x") ||
                                       die("No 'x' field in \"Position\" tag.");
   $self->{X} = AccentsXML2Text( $attrnode->getValue() );
   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("y") ||
                                       die("No 'y' field in \"Position\" tag.");
   $self->{Y} = AccentsXML2Text( $attrnode->getValue() );
   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("width") ||
                                   die("No 'width' field in \"Position\" tag.");
   $self->{WIDTH} = AccentsXML2Text( $attrnode->getValue() );
   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("height") ||
                                  die("No 'height' field in \"Position\" tag.");
   $self->{HEIGHT} = AccentsXML2Text( $attrnode->getValue() );

   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Data") || die("Zone: No \"Data\" tag.");
   $node = $list->item(0) || die("Zone: No \"Data\" tag.");

   my @expressions = ();
   for my $kid ($node->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Expression" )
      { push @expressions, new LogTrend::Visu::Expression( $kid, $systemsDeclaration ); }
   }
   $self->{EXPRESSIONS} = \@expressions;

   return $self;
}

##******************************************************************************
## Class-method newZone  public
##  Description  : creat a new Zone of the good class
##  Parameters   : the Zone XML node
##  Return value : a reference on the new Zone
##******************************************************************************
sub newZone
{
   my ($classname,$rootnode,$systemsDeclaration,$zone_nbr,$output_type) = @_;
   my ($list,$node,$valueref,$sublist,$subnode);
   my ($zone,$zoneClass,$name);

   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Type") || die("Zone: No \"Type\" tag.");
   $node = $list->item(0) || die("Zone: No \"Type\" tag.");

   ##---------------------------------------------------------------------------
   $sublist = $node->getElementsByTagName("*") || die("Type: No tag.");
   $subnode = $sublist->item(0) || die("No \"Type\" tag.");
   $name = $subnode->getNodeName();

   ### load perl package
   require "LogTrend/Visu/$output_type/Zone/${name}.pm";

   $zoneClass = "LogTrend::Visu::".$output_type."::Zone::".$name;
   eval { $zone = $zoneClass->new($subnode,$rootnode,$systemsDeclaration); };
   die("Type: \"$name\" tag: $@") if( $@ );

   ##===========================================================================
   ## For form report :
   $zone->setStartStop( ); # To be done after the construction

   $zone->{IDENT} = "z".sprintf("%03d",$zone_nbr);
   return $zone;
}

##******************************************************************************
## Method setStartStop  public
##  Description  : set start&stop variables (form report)
##  Parameters   : start&stop values
##  Return value : none
##******************************************************************************
sub setStartStop
{
   my ($self) = @_;
   my ($start,$stop) = $self->{SYSTEMSDECLARATION}->getStartStop();
   if( defined($start) and defined($stop) )
   {
      $self->{ORIGINAL_START} = $start;
      $self->{ORIGINAL_STOP}  = $stop;
      $self->{USE_ABSOLUTE_DATE} = 1;
   }
}

##******************************************************************************
## Method propagateInfos  public
##  Description  : propagates some informations to containned objects
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf,
##                 the screens' xml-id hashtable
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvas,$screenXmlId,$colSize) = @_;
   my $expressions = $self->{EXPRESSIONS};
   foreach my $var (@$expressions)
   {
      $var->propagateInfos( $canvas );
   }
   $self->{COLSIZE} = $colSize;

   # Note for $screenXmlId : 'Link' will over-load this method to use it
   # Note : 'Discs' will over-load this method for own convenience
}

##******************************************************************************
## Method ident  public
##  Description  : return the identificator value
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub ident
{
   my ($self) = @_;
   return $self->{IDENT};
}

##******************************************************************************
## Methods x y width height  public
##  Description  : return x y width or height value
##  Parameters   : none
##  Return value : the value
##******************************************************************************
sub x      { return $_[0]->{X};      }
sub y      { return $_[0]->{Y};      }
sub width  { return $_[0]->{WIDTH};  }
sub height { return $_[0]->{HEIGHT}; }

##******************************************************************************
## Method treat  virtual public
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
#  sub treat
#  {
#  }

##******************************************************************************
## Method whoAmI  public
##  Description  : prints a little description of the object
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub whoAmI
{
   my ($self) = @_;
   my $name = (split( /::/, ref $self ))[-1];
   return "[$name'$self->{TITLE}':x=".$self->x().",y=".$self->y().
                       ",w=".$self->width().",h=".$self->height()."]";
}

##******************************************************************************
1;
