#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Led.pm,v 1.4 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Led  isa Zone
##  Description  : class for printing messages
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Led.pm,v $
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.2  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.12  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.11  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.10  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.9  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.8  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.7  2001/06/26 16:50:54  slhullier
#
#Led sans image, message plus beaux ...
#
#Revision 1.6  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#
#Revision 1.5  2001/06/20 14:22:10  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.3  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.2  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Web::Zone::Led;

use strict;

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Led object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$attributes,$attrnode);

   ##===========================================================================
   ## Thresholds tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Thresholds");
   $node = $list->item(0);
   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Thresholds\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      {  $self->{WARNING} = $attrnode->getValue(); }
      # default = 0

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      {  $self->{CRITICAL} = $attrnode->getValue(); }
   }

   ##===========================================================================
   ## Colors3 tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Colors3");
   $node = $list->item(0);
   $self->      {OKCOLOR} = "#00FF00";
   $self-> {WARNINGCOLOR} = "#FFFF00";
   $self->{CRITICALCOLOR} = "#FF0000";

   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Colors3\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Ok");
      if( defined( $attrnode ) )
      { $self->{OKCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      { $self->{WARNINGCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      { $self->{CRITICALCOLOR} = TextToRGB( $attrnode->getValue() ); }

   }

   return $self;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   $response->contentType("text/html");
   $response->print("      $self->{TITLE}<BR>\n") if( $self->{TITLE} ne " " );

   my $expression = $self->{EXPRESSIONS}->[0];
   my $r = $expression->evalLast();

   if( !defined($r) )
   {
      $response->print( "      No data\n" );
   }
   else
   {
      my $color;
      if(    defined($self->{CRITICAL}) and $r > $self->{CRITICAL} )
      { $color = $self->{CRITICALCOLOR}; }
      elsif( defined($self->{WARNING})  and $r > $self->{WARNING} )
      { $color = $self->{WARNINGCOLOR}; }
      else
      { $color = $self->{OKCOLOR}; }

      $response->print("      <TABLE BORDER=\"0\" CELLPADDING=\"1\" CELLSPACING=\"0\"><TR>\n");
      $response->print("         <TD BGCOLOR=\"#000000\">");
      $response->print("            <TABLE BORDER=\"0\" WIDTH=\"50\" CELLPADDING=\"0\" CELLSPACING=\"0\"><TR>\n");
      $response->print("               <TD BGCOLOR=\"$color\"><FONT SIZE=\"-2\">&nbsp;</FONT></TD>\n");
      $response->print("            </TR></TABLE>\n");
      $response->print("         </TD></TR></TABLE>\n");
   }

   return $response;
}

##******************************************************************************
1;
