#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/VisuClass.pm,v 1.22 2001/12/05 16:32:36 slhullier Exp $
##******************************************************************************
## Class VisuClass
##  Description  : correspond to Class XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: VisuClass.pm,v $
#Revision 1.22  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.21  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#
#Revision 1.20  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.19  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.18  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.17  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.16  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.15  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.14  2001/10/24 12:00:39  slhullier
#First version for report-generation
#
#Revision 1.13  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#
#Revision 1.12  2001/08/24 09:05:31  slhullier
#
#DOM trees destruction
#
#Revision 1.11  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.10  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.9  2001/07/24 14:38:41  slhullier
#
#Scripting for Visu
#
#Revision 1.8  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.7  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.6  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.5  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::VisuClass;

use strict;
use XML::DOM;
use LogTrend::Visu::Screen;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Constants;

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rnode,$systemsDeclaration) = @_;
   my $self = {};
   bless($self, $classname);

   ##===========================================================================
   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;
   $self->{NAME} = $self->getNameFromXML( $rnode );
   if( !defined($self->{NAME}) )
   {                    # some systems are not wanted for reports or web
      $self = undef;
      return undef;
   }

   ##===========================================================================
   my $file = $self->{NAME};
   $file =~ s/[^a-zA-Z0-9]/_/g;
   $file = $systemsDeclaration->getXMLDirectory()."/$file.xml";

   ##===========================================================================
   my $parser = new XML::DOM::Parser() || die($!);
   open( FILE, "$file" ) || die("<CODE>$file</CODE>: $!");
   close(FILE);
   my $Utils_CurrentFile_Sav = $Utils_CurrentFile;
   $Utils_CurrentFile = "$file";

   my $doc = $parser->parsefile( $file ) || die("$!");

   my $rootlist = $doc->getElementsByTagName("Class") ||
                                         die("No \"Class\" tag.");
   my $rootnode = $rootlist->item(0) || die("No \"Class\" tag.");

   ##===========================================================================
   my %screen = ();
   my %screenXmlId = ();
   my $screen_nbr = 0;
   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Screen" )
      {
         my $s = $self->newScreen( $kid, $systemsDeclaration, $screen_nbr );
         $screen{$s->ident()} = $s;
         $screenXmlId{$s->screenXmlId()}  = $s->ident();
         $screen_nbr++;
      }
##       elsif( $nodeName eq "Name" ) ##
##       { ##
##          my $nameVisu = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); ##
##       } ##

   }

   ##===========================================================================
   $self->{SCREEN} = \%screen;
   $self->{SCREENXMLID} = \%screenXmlId;
   $doc->dispose();
   $doc = $parser = undef;

   $Utils_CurrentFile = $Utils_CurrentFile_Sav;
   return $self;
}

##******************************************************************************
## Method propagateInfos  public
##  Description  : propagates some informations to containned objects
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf,
##                 the SystemLeaf's name and description
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvas,$systemLeafName,$systemLeafDesc) = @_;
   my $screen = $self->{SCREEN};
   foreach my $var (keys %$screen)
   {
      $screen->{$var}->propagateInfos( $canvas, $systemLeafName, $systemLeafDesc,
                                       $self->{SCREENXMLID} );
   }

}

##******************************************************************************
1;
