#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/SystemLeaf.pm,v 1.23 2001/11/14 15:59:45 slhullier Exp $
##******************************************************************************
## Class SystemLeaf  isa ArchitectureNode
##  Description  : class for system (correspond to System XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemLeaf.pm,v $
#Revision 1.23  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.22  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.21  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.20  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.19  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.18  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.17  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.16  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#
#Revision 1.15  2001/08/21 08:45:07  slhullier
#
#Colors personnalisable + dial mis en place
#
#Revision 1.14  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.13  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.12  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.11  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.10  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.9  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.8  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.7  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::SystemLeaf;

use strict;

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::VisuClass;
use LogTrend::Visu::Canvas;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::ArchitectureNode");

##******************************************************************************
## Constructor  public
##  Parameters   : the root node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new();
   bless($self, $classname);

   my %canvas = ();
   $self->{DESCRIPTION} = "";

   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Class" )
      {
         my $class = $self->newVisuClass( $kid, $systemsDeclaration );
         if( !defined($class) )
         {                    # some systems are not wanted for reports or web
            $self = undef;
            return undef;
         }
         $self->{CLASS} = $class;
      }
      elsif( $nodeName eq "Name" )
      { $self->{NAME}  = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Description" )
      { $self->{DESCRIPTION} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Canvas" )
      {
         my $c = new LogTrend::Visu::Canvas( $kid, $systemsDeclaration );
         $canvas{$c->number()} = $c;
      }

   }

   die("No Name in System XML tag") if( !defined($self->{NAME}) );
   die("No Class in System XML tag") if( !defined($self->{CLASS}) );
   $self->{CANVAS} = \%canvas;

   $self->{CLASS}->propagateInfos( \%canvas, $self->{NAME}, $self->{DESCRIPTION} );

   return $self;
}

##******************************************************************************
## Method buildTree  public >ArchitectureNode
##  Description  : put this object in an HTML tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
}

##******************************************************************************
## Method treat  public >ArchitectureNode
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
}

##******************************************************************************
1;
