#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Zone/Graph.pm,v 1.17 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Report::Zone::Graph  isa Zone
##  Description  : class from which inherit Report(Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: Graph.pm,v $
#Revision 1.17  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.16  2001/11/19 08:23:18  lsimonneau
#Minor bugfixes.
#
#Revision 1.15  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.14  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.13  2001/11/05 14:36:22  slhullier
#text/docbook -> text/sgml
#
#Revision 1.12  2001/10/30 15:58:55  lsimonneau
#Now graph are in color.
#
#Revision 1.11  2001/10/30 08:02:19  slhullier
#Trying to fix accents bug
#
#Revision 1.10  2001/10/29 15:45:19  lsimonneau
#Add absolute date support for graph andReport/AlarmLog
#
#Revision 1.9  2001/10/29 15:40:22  slhullier
#*** empty log message ***
#
#Revision 1.8  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.7  2001/10/26 13:16:12  lsimonneau
#Add "last month" and "current month" to Duration possible values.
#Type is now deprecated for AlarmLog and AverageGraph.
#
#Revision 1.6  2001/10/26 11:55:06  lsimonneau
#Minor bugfixes.
#
#Revision 1.5  2001/10/25 15:07:21  lsimonneau
#ReportAverageGrah improvement.
#
#Revision 1.4  2001/10/25 13:40:59  lsimonneau
#Average Graph improvement.
#
#Revision 1.3  2001/10/25 07:22:58  slhullier
#Adding title into docbook
#
#Revision 1.2  2001/10/24 15:47:59  lsimonneau
#Add contentType informations.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.4  2001/10/24 07:41:55  slhullier
#Content type
#
#Revision 1.3  2001/10/23 14:29:41  lsimonneau
#Update Header.
#
#Revision 1.2  2001/10/23 14:19:58  slhullier
#;
#
#Revision 1.1  2001/10/23 12:06:24  lsimonneau
#First release of Report Zone.
#

package LogTrend::Visu::Report::Zone::Graph;

use strict;

use POSIX qw(strftime tmpnam);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Zone::Graph;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone::Graph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode, $systemsDeclaration);

   bless($self, $classname);

   return $self;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : none
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self) = @_;

   return $self->generatePicture( );
}


##******************************************************************************
## Method setDataStyle  protected
##  Description  : generate children specific the configuration line(s) for gnuplot
##  Parameters   :
##  Return value :
##******************************************************************************
sub setDataStyle
{
}

##******************************************************************************
## Method generatePicture  protected
##  Description  : generate the picture for the graph
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub generatePicture
{
   my ($self) = @_;

   my $response = new LogTrend::Visu::Response;
   $response->contentType("text/sgml");

   ## Print title
   $response->print("         <title>$self->{TITLE}</title>\n");

   my $ps_filename;

   my $i=0;
   while(-e "report-image-${i}.ps") { $i++ }

   $ps_filename = "report-image-${i}.ps";

   

   ### Run gnuplot
   open (F_GNUPLOT, "| gnuplot")
       or die("Can't run gnuplot : $!");

   ### Initial gnuplot params (postscript terminal, draw grid, border and legend,
   ### set time and tics format
   print F_GNUPLOT
       "set terminal postscript landscape color 12\n",
       "set encoding iso_8859_1\n",
       "set grid xtics ytics nomxtics nomytics nomx2tics nomy2tics\n",
       "set border\n",
       "set key below Left reverse\n",
       "set nox2tics\n",
       "set noy2tics\n",
       "set timefmt \"%m/%d/%Y %H:%M:%S\"\n",
       "set xdata time\n",
       "set output \"$ps_filename\"\n",
       "set size noratio 0.75, 0.75\n";

   if($self->{ORIGINAL_STOP} - $self->{ORIGINAL_START} <= 3600 * 24) {
       print F_GNUPLOT "set format x \"%H:%M\"\n";
   }

   if(defined $self->{TITLE}) {
       print F_GNUPLOT "set title \"$self->{TITLE}\"\n";
   }

   ### Set x/ytics frequency if X/Y_GRADUATION is set, lets gnuplot calculate it otherwise
   if(defined $self->{X_GRADUATION}) {
       print F_GNUPLOT "set xtics $self->{X_GRADUATION}\n";
   }

   if(defined $self->{Y_GRADUATION}) {
       print F_GNUPLOT "set ytics $self->{Y_GRADUATION}\n";
   }

   ### children specific parameters
   print F_GNUPLOT $self->setDataStyle;

   ### Get Data
   my $data = $self->evalExpression($self->{ORIGINAL_START}, $self->{ORIGINAL_STOP});
   my @tmpfilelist;
   my $graph_plot = "";

   my $x_lower_bound = time;
   my $x_upper_bound = 0;

   ### Build data files and gnuplot plot command string
   my $expr_nb = 0;
   my $max_val = 0;
   foreach my $expr (keys %$data) {
       next if $data->{$expr} == 0;

       my $filename = tmpnam;
       push @tmpfilelist, $filename;

       my $data_list = $data->{$expr};
       open(F_TMPFILE, ">$filename") or die "Can't open file $filename : $!";

       $x_lower_bound = $data_list->[0]->[1]  if $data_list->[0]->[1] < $x_lower_bound;
       $x_upper_bound = $data_list->[$#$data_list]->[1] if $data_list->[$#$data_list]->[1] > $x_upper_bound;

       foreach my $data (@$data_list) {
           my $time_string = strftime ("%m/%d/%Y %H:%M:%S", localtime($data->[1]));

           $max_val = $data->[0] if $data->[0] > $max_val;

           print F_TMPFILE "$time_string $data->[0]\n";
       }

       close F_TMPFILE;

       $graph_plot .= ", " if $graph_plot ne "";
       $graph_plot .= "\"$filename\" using 1:3 title \"$expr\"";
       if(defined $self->{LINESTYLES_NB} and $self->{LINESTYLES_NB} > 0) {
           $graph_plot .= "ls ".($expr_nb % $self->{LINESTYLES_NB} + 1);
       }

       $expr_nb ++;
   }

   ### If there are no data, return a text
   if($graph_plot eq "") {
       print F_GNUPLOT "quit\n";
       close F_GNUPLOT;
       $response->print("<para>There is no data to display.</para>\n");
       return $response;
   }

   ## Add label with time max/min
   my ($printed_time_min, $printed_time_max) = ($x_lower_bound, $x_upper_bound);
   if(defined $self->{FORCE_PRINTED_TIME_MIN}) {
       $printed_time_min = $self->{FORCE_PRINTED_TIME_MIN};
   }
   if(defined $self->{FORCE_PRINTED_TIME_MAX}) {
       $printed_time_max = $self->{FORCE_PRINTED_TIME_MAX};
   }

   print F_GNUPLOT "set label \"".strftime("%c", localtime($printed_time_min))."\" at screen 0.74,0.74 right font \"Helvetica, 8\"\n";
   print F_GNUPLOT "set label \"".strftime("%c", localtime($printed_time_max))."\" at screen 0.74,0.72 right font \"Helvetica, 8\"\n";

   ## set x range to avoid blank spaces at the left and the rigth of the curve
   $x_upper_bound = strftime ("%m/%d/%Y %H:%M:%S", localtime($x_upper_bound));
   $x_lower_bound = strftime ("%m/%d/%Y %H:%M:%S", localtime($x_lower_bound));
   print F_GNUPLOT "set xrange ['$x_lower_bound':'$x_upper_bound']\n";

   ## set y range if specified in XML file, lets gnuplot calculate it otherwise.
   if(defined $self->{ORIGINAL_Y_LOWERBOUNDARY} and defined $self->{ORIGINAL_Y_UPPERBOUNDARY}) {
       print F_GNUPLOT "set yrange [$self->{ORIGINAL_Y_LOWERBOUNDARY}:$self->{ORIGINAL_Y_UPPERBOUNDARY}]\n";
   }


   ### Change y format if requested
   if($max_val > 100000) {
       print F_GNUPLOT "set format y \"\%.0s \%c\"\n";
   }

   ### Plot the grapht
   print F_GNUPLOT "plot $graph_plot\n";

   close F_GNUPLOT;

   ### Remove data files
   foreach my $filename (@tmpfilelist) {
      unlink $filename;
   }

   ### Build response
   $response->print("         <graphic fileref=\"$ps_filename\" format=\"ps\" ></graphic>\n");

   return $response;
}

##******************************************************************************
1;
