#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Zone/AverageGraph.pm,v 1.6 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Report::Zonem::AverageGraph  isa Zone
##  Description  : class from which inherit Report::Zone::(Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: AverageGraph.pm,v $
#Revision 1.6  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.5  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.4  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.3  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.2  2001/10/25 15:07:21  lsimonneau
#ReportAverageGrah improvement.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.2  2001/10/23 14:29:41  lsimonneau
#Update Header.
#
#Revision 1.1  2001/10/23 12:06:24  lsimonneau
#First release of Report Zone.
#

package LogTrend::Visu::Report::Zone::AverageGraph;

use strict;

use POSIX qw(strftime tmpnam);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Report::Zone::LineGraph;
use LogTrend::Visu::Zone::AverageGraph;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone::AverageGraph", "LogTrend::Visu::Report::Zone::LineGraph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode, $systemsDeclaration);

   bless($self, $classname);

   return $self;
}



##******************************************************************************
## Method setDataStyle  protected
##  Description  : generate children specificthe configuration line(s) for gnuplot
##  Parameters   :
##  Return value :
##******************************************************************************
sub setDataStyle {
    my $self = shift;
    my $res = $self->LogTrend::Visu::Report::Zone::LineGraph::setDataStyle;

    $res .= "set linestyle 1 lt 2\n".
            "set linestyle 2 lt 3\n".
            "set linestyle 3 lt 1\n";

    $self->{LINESTYLES_NB} = 3;

    $res .= "set format x \"%H:%M\"\n";


    return  $res;
}
##******************************************************************************
1;
