#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Zone/Alarms.pm,v 1.5 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Report::Zone::Alarms  isa Zone
##  Description  : class from which inherit Report(Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: Alarms.pm,v $
#Revision 1.5  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.4  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.3  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.2  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.1  2001/11/07 16:06:56  lsimonneau
#*** empty log message ***
#
#Revision 1.9  2001/11/06 14:23:49  lsimonneau
#Add The Discs zone for report.
#Minor bugfixes in Expression.pm
#
#Revision 1.8  2001/11/05 14:36:22  slhullier
#text/docbook -> text/sgml
#
#Revision 1.7  2001/10/31 17:07:11  lsimonneau
#Remove backward compatibility for Type attribute.
#
#Revision 1.6  2001/10/29 15:46:44  lsimonneau
#*** empty log message ***
#
#Revision 1.4  2001/10/26 13:16:12  lsimonneau
#Add "last month" and "current month" to Duration possible values.
#Type is now deprecated for Alarms and AverageGraph.
#
#Revision 1.3  2001/10/26 08:16:39  lsimonneau
#Major bugfixes.
#
#Revision 1.2  2001/10/24 15:47:59  lsimonneau
#Add contentType informations.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 16:29:12  lsimonneau
#First release of Report Alarm Log zone.
#
#Revision 1.1  2001/10/23 12:06:24  lsimonneau
#First release of Report Zone.
#

package LogTrend::Visu::Report::Zone::Alarms;

use strict;

use POSIX qw(strftime tmpnam);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::TimeUtils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use Time::Local;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new ReportAlarms object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode, $realrootnode, $systemsDeclaration);

   bless($self, $classname);

   $self->parseXML($rootnode,$realrootnode);

   return $self;
}

##******************************************************************************
## parseXML  protected
##  Description  : parse bar graph specific xml entry
##  Parameters   :
##******************************************************************************
sub parseXML {
   my ($self, $rootnode,$realrootnode) = @_;
   my ($list,$node,$attributes,$attrnode);


   $list = $rootnode->getElementsByTagName("Time") || die("Error in \"Alarms\".");
   die("Error in \"Alarms\".") if (@$list == 0);
   $node = $list->[0];
   $attributes = $node->getAttributes() || die("Error in \"Alarms\".");

   ##===========================================================================
   ## Alarms tag
   ##===========================================================================
   my $now = time();

   ##---------------------------------------------------------------------------
   if( defined( $attrnode = $attributes->getNamedItem("Duration") ) )
   {
      $self->{ORIGINAL_START} = $now - Duration( $attrnode->getValue() );
      $self->{ORIGINAL_STOP}  = $now;
      $self->{USE_ABSOLUTE_DATE} = 1;
   }
   ##---------------------------------------------------------------------------
   elsif( defined( $attrnode = $attributes->getNamedItem("Interval") ) )
   {
      ($self->{ORIGINAL_START},$self->{ORIGINAL_STOP}) =
         TimeInterval( $attrnode->getValue() );
      $self->{USE_ABSOLUTE_DATE} = 1;
   }
   ##---------------------------------------------------------------------------
   else
   {
      $attrnode = $attributes->getNamedItem("Start") or
         die("No 'Start' field in \"X\" tag.");
      my $start_val = $attrnode->getValue();

      $attrnode = $attributes->getNamedItem("Stop") or
         die("No 'Stop' field in \"X\" tag.");
      my $stop_val = $attrnode->getValue();

      my ($start,$stop,$absDate) = StartStop( $start_val, $stop_val );
      if( $absDate == 1 )
      {
         $self->{ORIGINAL_START} = $start;
         $self->{ORIGINAL_STOP}  = $stop;
         $self->{USE_ABSOLUTE_DATE} = 1;
      }
      else
      {
         $self->{ORIGINAL_START} = $now - $start;
         $self->{ORIGINAL_STOP}  = $now - $stop;
         $self->{USE_ABSOLUTE_DATE} = 1;
      }
   }

}


##******************************************************************************
## getAlarms  private
##  Description  : return Alarms
##  Parameters   :
##******************************************************************************
sub getAlarms {
    my $self = shift;

    my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();

    my $expressions = $self->{EXPRESSIONS};
    my $expressionsNb = @$expressions;

    my %alarms;

    for( my $e=0; $e<$expressionsNb; $e++ )
    {
        my $res = $dataBase->GetAlarmsInTimeInterval(100000,
                                                     $expressions->[$e]->source,
                                                     $expressions->[$e]->agent,
                                                     $self->{ORIGINAL_START}, $self->{ORIGINAL_STOP});

        $alarms{$expressions->[$e]->label} = $res;
    }

    return \%alarms;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response;
   $response->contentType("text/sgml");

   $response->print("<title>$self->{TITLE}</title>\n");

   my $alarms = $self->getAlarms;

   my $table = "";
   foreach my $key (keys %$alarms) {
       next if $alarms->{$key} == 0;

       my %alarms_by_type;
       foreach my $a (@{$alarms->{$key}}) {
           push @{$alarms_by_type{$a->[1]}}, [$a->[0], $a->[2], $a->[3]];
       }

       foreach my $key (keys %alarms_by_type) {
           $table .= "<section>\n".
                     "<title>$key</title>\n".
                     "<informaltable frame=\"all\">\n".
                     "<tgroup cols=\"3\" colsep=\"1\" rowsep=\"1\" align=\"center\">\n".
                     "<thead>\n".
                     "<row>\n".
                     "<entry>Level</entry>\n".
                     "<entry>Release date</entry>\n".
                     "<entry>Acquitted</entry>\n".
                     "</row>\n".
                     "</thead>\n".
                     "<tbody>\n";

           foreach my $a (@{$alarms_by_type{$key}}) {
               $table .= "<row>\n".
                         "<entry>".(("Info", "Warning", "Critical")[$a->[0]-1])."</entry>\n".
                         "<entry>".gmtime($a->[1])."</entry>\n".
                         "<entry>".((defined $a->[2]) ? "Yes":"No")."</entry>\n".
                         "</row>\n";
           }

           $table .= "</tbody>\n".
                     "</tgroup>\n".
                     "</informaltable>\n".
                     "</section>\n";
       }
   }

   if($table eq "") {
       $response->print("<para>No Alarms</para>\n");
   }
   else {
       $response->print($table);
   }


   return $response;
}


1;
