#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Screen.pm,v 1.6 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Screen isa LogTrend::Visu::Screen
##  Description  : correspond to the Zone XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Screen.pm,v $
#Revision 1.6  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.5  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.4  2001/11/05 14:36:22  slhullier
#text/docbook -> text/sgml
#
#Revision 1.3  2001/10/30 15:02:52  lsimonneau
#utf8 bug with old perl version fixed.
#
#Revision 1.2  2001/10/26 06:54:54  slhullier
#Bug correction
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::Screen;

use strict;
use LogTrend::Common::LogDie;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Screen;
use LogTrend::Visu::Zone;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Screen");

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node, the screen number
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration,$screen_nbr) = @_;
   my ($outputType) = ($classname =~ /.*::([^:]*)::[^:]*/);
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration,$screen_nbr,$outputType);
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method treat  buildTree
##  Description  : build the report
##  Parameters   : none
##  Return value : docbook string
##******************************************************************************
sub buildTree
{
   my ($self) = @_;
   my $zone = $self->{ZONE};
   my $result = "";

   my $positions = $self->{POSITIONS};
   my $positions_x_max = $self->{POSITIONS_X_MAX};
   my $positions_y_max = $self->{POSITIONS_Y_MAX};
   my %done = ();

   ##---------------------------------------------------------------------------
   ## For each position
   ##---------------------------------------------------------------------------
   for( my $y=0; $y<=$positions_y_max; $y++ )
   {
      next if( !defined( $positions->{"0,$y"} ) );

      for( my $x=0; $x<=$positions_x_max; $x++ )
      {
            my $zoneIdent = $positions->{"$x,$y"};
            next if( $zoneIdent eq ".." );
            if( !defined( $done{$zoneIdent} ) )
            {
               $done{$zoneIdent} = 1;
               my $zoneRef = $zone->{$zoneIdent};

               my $zoneResponse = $zoneRef->treat( );
               if( $zoneResponse->contentType() eq "text/sgml" )
               {
                  $result .= "      <section>\n";
                  $result .= $zoneResponse->getContent();
                  $result .= "      </section>\n";
               }
               else
               {
                  Die("Unexpected content-type (".$zoneResponse->contentType().")");
               }

            }
            else
            {
               # rien
            }
      }
   }

   return $result;
}

##******************************************************************************
1;
