#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/NetworkNode.pm,v 1.5 2001/11/14 14:13:48 slhullier Exp $
##******************************************************************************
## Class NetworkNode  isa LogTrend::Visu::NetworkNode isa ArchitectureNode
##  Description  : class for network (correspond to Network XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: NetworkNode.pm,v $
#Revision 1.5  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.3  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.2  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::NetworkNode;

use strict;

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Report::SystemLeaf;
use LogTrend::Visu::Report::NetworkNode;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::NetworkNode");

##******************************************************************************
## Constructor  public
##  Parameters   : the root node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub newNetworkNode
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Report::NetworkNode( $kid, $systemsDeclaration );
}

##******************************************************************************
sub newSystemLeaf
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Report::SystemLeaf( $kid, $systemsDeclaration );
}

##******************************************************************************
## Method buildTree_header  protected >LogTrend::Visu::NetworkNode
##  Description  : called by buildTree for the header
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub buildTree_header
{
   my ($self,$dir) = @_;
   my $result = "";

   if(    length($dir) == 0 ) { $result .= "<part>\n"; }
   elsif( length($dir) == 4 ) { $result .= "<chapter>\n"; }
   else                       { $result .= "<section>\n"; }

   $result .= "    <title>$self->{NAME}</title>\n";

   return $result;
}

##******************************************************************************
## Method buildTree_footer  protected
##  Description  : called by buildTree for the footer
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub buildTree_footer
{
   my ($self,$dir) = @_;
   my $result = "";

   if(    length($dir) == 0 ) { $result .= "</part>\n"; }
   elsif( length($dir) == 4 ) { $result .= "</chapter>\n"; }
   else                       { $result .= "</section>\n"; }

   return $result;
}

##******************************************************************************
1;
