#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Canvas.pm,v 1.8 2001/11/19 10:56:54 slhullier Exp $
##******************************************************************************
## Class Canvas
##  Description  : correspond to the Canvas XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Canvas.pm,v $
#Revision 1.8  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.7  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.6  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.5  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.4  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Canvas;

use strict;
use XML::DOM;
use LogTrend::Visu::SystemsDeclaration;
use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = {};
   bless($self, $classname);

   my $attributes = $rootnode->getAttributes() || die("Error in \"Canvas\" tag.");
   my $attrnode = $attributes->getNamedItem("Number") ||
                   die("No 'Number' field in \"Canvas\" tag.");
   $self->{NUMBER} = AccentsXML2Text( $attrnode->getValue() );

   $attrnode = $attributes->getNamedItem("Entity_Number") ||
                   die("No 'Entity_Number' field in \"Canvas\" tag.");
   my $entityNumber = undef;
   $entityNumber = AccentsXML2Text( $attrnode->getValue() );

   die("No \'Entity_Number\' in \"Canvas\" XML tag") if( !defined($entityNumber) );

   $self->{ENTITY} = $systemsDeclaration->getEntity( $entityNumber );

   return $self;
}

##******************************************************************************
## Method number  public
##  Description  : returns the number of a Canvas
##  Parameters   : none
##  Return value : the number
##******************************************************************************
sub number
{
   my ($self) = @_;
   return $self->{NUMBER};
}

##******************************************************************************
## Method source  public
##  Description  : returns the source for the Canvas
##  Parameters   : none
##  Return value : the number
##******************************************************************************
sub source
{
   my ($self) = @_;
   return $self->{ENTITY}->source();
}

##******************************************************************************
## Method agentNumber  public
##  Description  : returns the agent-number for the Canvas
##  Parameters   : none
##  Return value : the agent-number
##******************************************************************************
sub agentNumber
{
   my ($self) = @_;
   return $self->{ENTITY}->agentNumber();
}

##******************************************************************************
1;
