#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Action/SMS/genie.pm,v 1.1 2001/10/31 16:44:53 lsimonneau Exp $

##*****************************************************************************
##  genie.pm
##  Description  : Specific function for www.genie.fr Free sms service
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package genie;

use strict;
use LWP;
use HTTP::Request;
use HTTP::Response;
use HTTP::Cookies;

##*****************************************************************************
##  get_jscript_cookies (a Postrequest function)
##  Description  : create cookies form the java script data
##
##  Parameters   : none
##*****************************************************************************
sub get_jscript_cookies {
    my ($user_agent, $request, $response) = @_;
    my $url = $response->request->url;
    my $req_port = $url->port;
    my $html_data = $response->content;

    my $cookie_jar = $user_agent->cookie_jar;

    while($html_data =~ s/document\.cookie = "(\w+)" \+ "=" \+ escape\("(.+)"\)\s?\+ "\; path=(.+)\; domain=(.+)\;"\;//) {
	$cookie_jar->set_cookie(0, $1, $2, $3 ,$4, undef, 1, undef, undef, 1);
    }
}

1;
