#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/DataBaseAccess/DataBase.pm,v 1.7 2001/09/17 13:58:40 lsimonneau Exp $
##*****************************************************************************
##  DataBase
##  Description  : DataBase is an abstact class for LogTrend Database access
##                 
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: DataBase.pm,v $
#Revision 1.7  2001/09/17 13:58:40  lsimonneau
#Major feature enhancements : Add a methods called GetDataInRelativeTimeInterval.
#
#Revision 1.6  2001/07/31 09:54:51  lsimonneau
#Amlioration des performances.
#
#Revision 1.5  2001/07/30 11:43:42  lsimonneau
#Ajout de l'option disable_ancestor et modification de la doc.
#
#Revision 1.4  2001/06/25 13:01:31  slhullier
#
#Destroy ssi self existe
#
#Revision 1.3  2001/06/11 08:59:54  lsimonneau
#Correction d'un bug : GetListOfAgentsOnSource, il manquait le s a Agents dans le fichier DataBase.pm.
#
#Revision 1.2  2001/06/07 13:06:13  lsimonneau
#Changement du nom des package (DataBase -> LogTrend::DataBaseAccess::DataBase)
#
#Revision 1.1  2001/05/28 07:30:24  slhullier
#
#Fichiers DataBase
#


use DBI;


package LogTrend::DataBaseAccess::DataBase;

##*****************************************************************************
## Constructor  public
##  Description  : creat a new DataBase
##
##  Parameters   : The database name,
##                 The database server host name,
##                 The database server port,
##                 An username and a password of a database user
##*****************************************************************************
sub new
{
    my ($classname, $databasename, $host, $port, $username, $password) = @_;
    my $self = {};

    bless($self, $classname);

    $self->connect($databasename, $host, $port, $username, $password);

    return $self;
}


##*****************************************************************************
## connect protected
##  Description  : Try to establish a connection with the database
##  Parameters   : none
##*****************************************************************************
sub connect
{
}


##*****************************************************************************
## disconnect protected
##  Description  : Disconnect from the database
##  Parameters   : none
##*****************************************************************************
sub disconnect
{
}


##*****************************************************************************
##  GetData public
##  Description  : Return the last stored data
##
##  Parameters   : The source name,
##                 The agent name,
##                 The data name.
##*****************************************************************************

sub GetData {
}


##*****************************************************************************
##  GetDataType public
##  Description  : Return the type of the data
##
##  Parameters   : The source name,
##                 The agent name,
##                 The data name,
##                 Enable ancestor. String with 'enable_ancestor' or 'disable_ancestor'. 
##                                  Default value is 'enable_ancestor'.
##*****************************************************************************

sub GetDataType {
}


##*****************************************************************************
##  GetDataInTimeInterval public
##  Description  : Return all data in the specifed time interval
##
##  Parameters   : The maximum number of data to retrieve,
##                 The source name,
##                 The agent name,
##                 The data name,
##                 The start date,
##                 The end date (optional).
##*****************************************************************************

sub GetDataInTimeInterval {
}

##*****************************************************************************
##  GetDataInRelativeTimeInterval public
##  Description  : Return all data in the specifed relative time interval
##
##  Parameters   : The maximum number of data to retrieve,
##                 The source name,
##                 The agent name,
##                 The data name,
##                 The start date (relative to last connection date),
##                 The end date (relative to last connection date) (optional).
##*****************************************************************************

sub GetDataInRelativeTimeInterval {
}

##*****************************************************************************
##  GetSeveralDataInTimeInterval public
##  Description  : Return all data in the specifed time interval
##
##  Parameters   : The maximum number of data to retrieve per
#                  (source, agent, data_name).
##                 The source list,
##                 The agent list,
##                 The data name list,
##                 The start date list,
##                 The end date list (optional),
##                 Enable ancestor. String with 'enable_ancestor' or 'disable_ancestor'. 
##                                  Default value is 'enable_ancestor'.
##*****************************************************************************

sub GetSeveralDataInTimeInterval {
    my ($self, $max_data, $source_list, $agent_list, $name_list, $start_list, $end_list, $enable_ancestor) = @_;
    my $result;

    my %returned_hash;

      if(!(defined $end_list) and !(defined $enable_ancestor)) {
  	$enable_ancestor = 'enable_ancestor';
      }
      elsif(defined $end_list and !(defined $enable_ancestor)) {
  	if($end_list eq 'disable_ancestor') { 
  	    $enable_ancestor = $end_list;
  	    $end_list = undef;
  	}
  	else {
  	    $enable_ancestor = 'enable_ancestor';
  	}
      }

    for($index = 0; $index <= $#$source_list; $index++) {

	if(defined $end_list) {
	    $result = $self->GetDataInTimeInterval($max_data, $source_list->[$index], $agent_list->[$index], $name_list->[$index], $start_list->[$index], $end_list->[$index], $enable_ancestor);
	}
	else {
	    $result = $self->GetDataInTimeInterval($max_data, $source_list->[$index], $agent_list->[$index], $name_list->[$index], $start_list->[$index], $enable_ancestor);
	}

	$returned_hash{"$source_list->[$index], $agent_list->[$index], $name_list->[$index]"} = $result;
    }    

    return \%returned_hash;
}


##*****************************************************************************
##  GetSeveralDataType public
##  Description  : Return the type of the data
##
##  Parameters   : The source name list,
##                 The agent name list ,
##                 The data name list,
##*****************************************************************************

sub GetSeveralDataType {
    my ($self, $source_list, $agent_list, $name_list) = @_;
    my $result;

    my %returned_hash;
    
    for($index = 0; $index <= $#$source_list; $index++) {
	
	$result = $self->GetDataType($source_list->[$index], $agent_list->[$index], $name_list->[$index]);
	
	$returned_hash{"$source_list->[$index], $agent_list->[$index], $name_list->[$index]"} = $result;
    }    

    return \%returned_hash;
}


##*****************************************************************************
##  GetCollectionDateInTimeInterval public
##  Description  : Return the list of collection date for a specified data
##
##  Parameters   : The source name,
##                 The agent name,
##                 The data name,
##                 The start date,
##                 The end date (optional).
##                 Enable ancestor. String with 'enable_ancestor' or 'disable_ancestor'. 
##                                  Default value is 'enable_ancestor'.
##*****************************************************************************

sub GetCollectionDateInTimeInterval {    
}


##*****************************************************************************
##  GetAlarms public
##  Description  : Return all non acquitted alarms an complex alarms of an agent
##
##  Parameters   : The source name,
##                 The agent name,
##*****************************************************************************

sub GetAlarms {
}


##*****************************************************************************
##  GetAlarmsInTimeinterval public
##  Description  : Return all alarm and complex alarms in a time interval
##
##  Parameters   : The maximum number of data to retrieve,
##                 The source name,
##                 The agent name,
##*****************************************************************************

sub GetAlarmsInTimeInterval {
}


##*****************************************************************************
##  GetSeveralAlarmsInTimeinterval public
##  Description  : Return all alarm and complex alarms in a time interval
##
##  Parameters   : The maximum number of data to retrieve,
##                 The source name,
##                 The agent name,
##                 The start date list,
##                 The end date list (optional).
##*****************************************************************************

sub GetSeveralAlarmsInTimeInterval {
    my ($self, $max_data, $source_list, $agent_list, $start_list, $end_list) = @_;
    my $result;

    my %returned_hash;

    for($index = 0; $index <= $#$source_list; $index++) {

	if(defined $end_list) {
	    $result = $self->GetAlarmsInTimeInterval($max_data, $source_list->[$index], $agent_list->[$index], $start_list->[$index], $end_list->[$index]);
	}
	else {
	    $result = $self->GetAlarmInTimeInterval($max_data, $source_list->[$index], $agent_list->[$index], $start_list->[$index]);
	}

	$returned_hash{"$source_list->[$index], $agent_list->[$index], $name_list->[$index]"} = $result;
    }    

    return \%returned_hash;
}


##*****************************************************************************
##  GetSourcesList public
##  Description  : Return the list of sources
##
##  Parameters   : none
##*****************************************************************************

sub GetSourcesList {
}


##*****************************************************************************
##  GetListOfAgentsOnSource public
##  Description  : Return the list of agents on a source.
##
##  Parameters   : The source name.
##*****************************************************************************

sub GetListOfAgentsOnSource {
}


##*****************************************************************************
##  GetListOfDataNameOnAgent public
##  Description  : Return the list of agents on a source.
##
##  Parameters   : The source name,
##                 The agent name.
##*****************************************************************************

sub GetListOfDataNameOnAgent {
}


##*****************************************************************************
##  DESTROY public
##  Description  : Disconnect form the database
##
##  Parameters   : The source name,
##                 The agent name,
##*****************************************************************************

sub DESTROY {
    my $self = shift;
    $self->disconnect() if( defined( $self ) );
}

1;

