#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Function/FunctionLoader.pm,v 1.4 2001/07/25 12:14:53 lsimonneau Exp $
##*****************************************************************************
##  Package FunctionLoader 
##  Description  : A method for dynamic loading of detection functions package
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: FunctionLoader.pm,v $
#Revision 1.4  2001/07/25 12:14:53  lsimonneau
#Minor bugfixes.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#


package LogTrend::ComplexAlarm::Function::FunctionLoader;

use strict;
use LogTrend::ComplexAlarm::Function::DetFuncStdlib;

##*****************************************************************************
## Method LoadFunction
##  Description  : Try to load a detection function package
##                 A detection function package should implement 
##                 two functions, Properties and Run.
##  Parameters   : A package name
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
sub LoadFunction 
{
    my $pkgname = shift;
    my $nb_func;
    my $filename;

    # check if the package is already loaded (by a previous 'LoadFunction'
    # or by 'use DetFuncStdlib'
    if(defined &{"LogTrend::ComplexAlarm::Function::${pkgname}::Properties"} && defined &{"LogTrend::ComplexAlarm::Function::${pkgname}::Run"}){
	return 1;
    }

    # check if the file $pkgname.pm exist
    my $default_path= __FILE__;
    $default_path =~ s/\/FunctionLoader.pm$//;
    
    if(-f "$default_path/${pkgname}.pm") {
	$filename = "$default_path/${pkgname}.pm";
    }
    # check if the environment variable DET_FUNC_PATH is set
    elsif(defined $ENV{DET_FUNC_PATH}){
	foreach my $path (split /:/, $ENV{DET_FUNC_PATH}) {
	    if(-f "$path/${pkgname}.pm") {
		$filename = "$path/${pkgname}.pm";
		last;
	    }
	}
    }

    if(! defined $filename) {
	die "can't find package $pkgname\n";
    }
    
    # check if this package contains required functions
    open(PACKAGE_FILE, $filename);

    $nb_func=0;
    while(<PACKAGE_FILE>) {
	# look for '#!/usr/bin/perl'
	$_ =~ /^\s*\#!\/usr\/(local\/)?bin\/perl/ and $nb_func++;

	# look for 'sub Run'
	$_ =~ /^\s*sub\s+Run\s*\{?\s*$/ and $nb_func++;

	# look for 'sub Properties'
	$_ =~ /^\s*sub\s+Properties\s*\{?\s*$/ and $nb_func++;
    }
    
    close(PACKAGE_FILE);

    if($nb_func!=3){
	die "$pkgname is not a valid detection function package\n";
	return 0;
    }
    
    # load this file
    require($filename);
        
    # check if the required func are loaded
    if(! defined &{"LogTrend::ComplexAlarm::Function::${pkgname}::Properties"} && defined &{"LogTrend::ComplexAlarm::Function::${pkgname}::Run"}){
	die "$pkgname is not a valid Detection Function package\n";
	return 0;
    }
    
    return 1;
}

1;
