//===-- SBWatchpoint.h ----------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SBWatchpoint_h_
#define LLDB_SBWatchpoint_h_

#include "lldb/API/SBDefines.h"

namespace lldb {

class SBWatchpoint
{
public:

    SBWatchpoint ();

    SBWatchpoint (const lldb::SBWatchpoint &rhs);

    SBWatchpoint (const lldb::WatchpointSP &wp_sp);

    ~SBWatchpoint ();

    const lldb::SBWatchpoint &
    operator = (const lldb::SBWatchpoint &rhs);

    bool
    IsValid() const;

    SBError
    GetError();

    watch_id_t
    GetID ();

    /// With -1 representing an invalid hardware index.
    int32_t
    GetHardwareIndex ();

    lldb::addr_t
    GetWatchAddress ();

    size_t
    GetWatchSize();

    void
    SetEnabled(bool enabled);

    bool
    IsEnabled ();

    uint32_t
    GetHitCount ();

    uint32_t
    GetIgnoreCount ();

    void
    SetIgnoreCount (uint32_t n);

    const char *
    GetCondition ();

    void 
    SetCondition (const char *condition);
    
    bool
    GetDescription (lldb::SBStream &description, DescriptionLevel level);

    void
    Clear ();

    lldb::WatchpointSP
    GetSP () const;

    void
    SetSP (const lldb::WatchpointSP &sp);

private:
    friend class SBTarget;
    friend class SBValue;

    
    lldb::WatchpointSP m_opaque_sp;

};

} // namespace lldb

#endif  // LLDB_SBWatchpoint_h_
