; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --force-update
; RUN: llc -verify-machineinstrs -mtriple=aarch64-- -O1 -fast-isel=0 -global-isel=false %s -o - | FileCheck %s -check-prefix=NOLSE
; RUN: llc -verify-machineinstrs -mtriple=aarch64-- -mattr=+lse -O1 -fast-isel=0 -global-isel=false %s -o - | FileCheck %s -check-prefix=LSE

define half @test_rmw_xchg_f16(half* %dst, half %new) {
; NOLSE-LABEL: test_rmw_xchg_f16:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    // kill: def $h0 killed $h0 def $s0
; NOLSE-NEXT:    fmov w8, s0
; NOLSE-NEXT:  .LBB0_1: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Inner Loop Header: Depth=1
; NOLSE-NEXT:    ldaxrh w9, [x0]
; NOLSE-NEXT:    stlxrh w10, w8, [x0]
; NOLSE-NEXT:    cbnz w10, .LBB0_1
; NOLSE-NEXT:  // %bb.2: // %atomicrmw.end
; NOLSE-NEXT:    fmov s0, w9
; NOLSE-NEXT:    // kill: def $h0 killed $h0 killed $s0
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_rmw_xchg_f16:
; LSE:       // %bb.0:
; LSE-NEXT:    // kill: def $h0 killed $h0 def $s0
; LSE-NEXT:    fmov w8, s0
; LSE-NEXT:    swpalh w8, w8, [x0]
; LSE-NEXT:    fmov s0, w8
; LSE-NEXT:    // kill: def $h0 killed $h0 killed $s0
; LSE-NEXT:    ret
  %res = atomicrmw xchg half* %dst, half %new seq_cst
  ret half %res
}

define float @test_rmw_xchg_f32(float* %dst, float %new) {
; NOLSE-LABEL: test_rmw_xchg_f32:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    fmov w9, s0
; NOLSE-NEXT:  .LBB1_1: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Inner Loop Header: Depth=1
; NOLSE-NEXT:    ldaxr w8, [x0]
; NOLSE-NEXT:    stlxr w10, w9, [x0]
; NOLSE-NEXT:    cbnz w10, .LBB1_1
; NOLSE-NEXT:  // %bb.2: // %atomicrmw.end
; NOLSE-NEXT:    fmov s0, w8
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_rmw_xchg_f32:
; LSE:       // %bb.0:
; LSE-NEXT:    fmov w8, s0
; LSE-NEXT:    swpal w8, w8, [x0]
; LSE-NEXT:    fmov s0, w8
; LSE-NEXT:    ret
  %res = atomicrmw xchg float* %dst, float %new seq_cst
  ret float %res
}

define double @test_rmw_xchg_f64(double* %dst, double %new) {
; NOLSE-LABEL: test_rmw_xchg_f64:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    fmov x8, d0
; NOLSE-NEXT:  .LBB2_1: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Inner Loop Header: Depth=1
; NOLSE-NEXT:    ldaxr x9, [x0]
; NOLSE-NEXT:    stlxr w10, x8, [x0]
; NOLSE-NEXT:    cbnz w10, .LBB2_1
; NOLSE-NEXT:  // %bb.2: // %atomicrmw.end
; NOLSE-NEXT:    fmov d0, x9
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_rmw_xchg_f64:
; LSE:       // %bb.0:
; LSE-NEXT:    fmov x8, d0
; LSE-NEXT:    swpal x8, x8, [x0]
; LSE-NEXT:    fmov d0, x8
; LSE-NEXT:    ret
  %res = atomicrmw xchg double* %dst, double %new seq_cst
  ret double %res
}

define fp128 @test_rmw_xchg_f128(fp128* %dst, fp128 %new) {
; NOLSE-LABEL: test_rmw_xchg_f128:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    sub sp, sp, #32 // =32
; NOLSE-NEXT:    .cfi_def_cfa_offset 32
; NOLSE-NEXT:    str q0, [sp, #16]
; NOLSE-NEXT:    ldp x9, x8, [sp, #16]
; NOLSE-NEXT:  .LBB3_1: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Inner Loop Header: Depth=1
; NOLSE-NEXT:    ldaxp x11, x10, [x0]
; NOLSE-NEXT:    stlxp w12, x9, x8, [x0]
; NOLSE-NEXT:    cbnz w12, .LBB3_1
; NOLSE-NEXT:  // %bb.2: // %atomicrmw.end
; NOLSE-NEXT:    stp x11, x10, [sp]
; NOLSE-NEXT:    ldr q0, [sp], #32
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_rmw_xchg_f128:
; LSE:       // %bb.0:
; LSE-NEXT:    sub sp, sp, #32 // =32
; LSE-NEXT:    .cfi_def_cfa_offset 32
; LSE-NEXT:    str q0, [sp, #16]
; LSE-NEXT:    ldp x9, x8, [sp, #16]
; LSE-NEXT:  .LBB3_1: // %atomicrmw.start
; LSE-NEXT:    // =>This Inner Loop Header: Depth=1
; LSE-NEXT:    ldaxp x11, x10, [x0]
; LSE-NEXT:    stlxp w12, x9, x8, [x0]
; LSE-NEXT:    cbnz w12, .LBB3_1
; LSE-NEXT:  // %bb.2: // %atomicrmw.end
; LSE-NEXT:    stp x11, x10, [sp]
; LSE-NEXT:    ldr q0, [sp], #32
; LSE-NEXT:    ret
  %res = atomicrmw xchg fp128* %dst, fp128 %new seq_cst
  ret fp128 %res
}
