/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include <gdk/gdkkeysyms.h>
#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

gboolean set_direction_by_key (LWWizard *wizard, guint key)
{
	switch (key) {
		case GDK_Up:
		case GDK_KP_Up:
			wizard->setDirection (LW_DIRECTION_NORTH);
			break;

		case GDK_Right:
		case GDK_KP_Right:
			wizard->setDirection (LW_DIRECTION_EAST);
			break;
		
		case GDK_Down:
		case GDK_KP_Down:
			wizard->setDirection (LW_DIRECTION_SOUTH);
			break;
			
		case GDK_Left:
		case GDK_KP_Left:
			wizard->setDirection (LW_DIRECTION_WEST);
			break;
		
		default:
			return FALSE;
	}

	return TRUE;
}

class LWCommandControl: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 0, NULL);
	
	while (FALSE == g_queue_is_empty (context->queue_keys)) {
		guint key = GPOINTER_TO_UINT(g_queue_pop_head (context->queue_keys));
		if (TRUE == set_direction_by_key (context->wizard, key)) {
			return NULL;
		}
	}

	return NULL;
}	

gchar *getName (void) 
{
	return "control";
}	

gchar *getHint ()
{
	return _("Turn wizard in direction requested by the user");
}

void checkArgc (guint n)
{
	if (n != 0) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandControl()
{
	return new LWCommandControl();
}
