<?xml version="1.0"?>
<!--  Note:  exclude-result-prefixes isn't supported by sablotron -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRML/"
  exclude-result-prefixes="lire">

  <!-- This is the target width of the table in MM -->
  <xsl:param name="debug" select="false()"/>

  <!-- Control userlevel of the description -->
  <xsl:param name="userlevel" select="'normal'"/>
  <xsl:param name="tablewidth" select="150"/>

  <xsl:output method="xml" omit-xml-declaration="no" indent="yes"
    doctype-public="-//OASIS//DTD DocBook XML V4.1.2//EN"
    doctype-system="http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd"/>

  <xsl:template match="/lire:report">
    <!-- Check for version number, we support only 2.0 -->
    <xsl:if test="@version &lt; 2.0">
      <xsl:message terminate="yes">Please convert your XML report to the 2.0 format.</xsl:message>
    </xsl:if>

    <article>
      <title>Lire <xsl:value-of select="lire:section/lire:subreport/@superservice"/> Report</title>

      <segmentedlist>
	<segtitle>Report generated</segtitle>
	<segtitle>Reporting on period</segtitle>
	<seglistitem>
	  <seg><xsl:value-of select="lire:date"/></seg>
	  <seg><xsl:value-of select="lire:timespan"/></seg>
	</seglistitem>
      </segmentedlist>

      <xsl:apply-templates select="lire:section"/>
    </article>
  </xsl:template>

  <xsl:template match="lire:section">
    <sect1>
      <title>
        <xsl:value-of select="lire:title"/>
      </title>
      <xsl:if test="lire:description">
	<xsl:apply-templates select="lire:description"/>
      </xsl:if>
      <xsl:choose>
	<xsl:when test="lire:subreport">
	  <xsl:apply-templates select="lire:subreport"/>
	</xsl:when>
	<xsl:otherwise>
	  <para>No subreports were generated for this section.</para>
	</xsl:otherwise>
      </xsl:choose>
    </sect1>
  </xsl:template>
  
  <xsl:template match="lire:subreport">
    <sect2 id="{generate-id(.)}">
      <title>
        <xsl:value-of select="lire:title"/>
      </title>
      <xsl:apply-templates select="lire:description"/>
      <xsl:apply-templates select="lire:image"/>
      <xsl:apply-templates select="lire:table"/>
    </sect2>
  </xsl:template>

  <xsl:template match="lire:description">
    <xsl:if test="$debug">
      <xsl:message>userlevel=<xsl:value-of select="$userlevel"/></xsl:message>
    </xsl:if>

    <xsl:choose>
      <xsl:when test="$userlevel = 'advanced'">
	<xsl:apply-templates mode="docbook.advanced"/>	  
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates mode="docbook.normal"/>	  
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="docbook.normal">
    <xsl:choose>
      <xsl:when test="@userlevel">
      <!-- Copy only of userlevel is normal -->
	<xsl:if test="@userlevel = 'normal'">
	  <xsl:copy-of select="."/>
	</xsl:if>
      </xsl:when>

      <!-- No userlevel attribute : copy -->
      <xsl:otherwise>
	<xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="docbook.advanced">
    <!-- Copy all elements -->
    <xsl:copy-of select="."/>
  </xsl:template>

  <!-- PassiveTeX doesn't support proportional so compute
  the width of the column here 
  The current node must be a column-info element 
  -->
  <xsl:template name="column.width">
    <xsl:variable name="total-chars" 
      select="sum(ancestor::lire:table-info//lire:column-info/@col-width)"/>

    <!-- To determine the column width, we use the col-width as 
    relative width on the target $tablewidth specified -->
    <xsl:value-of 
      select="concat( round($tablewidth * (@col-width div $total-chars)), 'mm')"/>
  </xsl:template>

  <!-- The current node must be a column-info element -->
  <xsl:template name="column.alignment">
    <xsl:choose>
      <xsl:when test="@class = 'categorical'">
	<xsl:value-of select="'left'"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'right'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- The current node must be a column-info element -->
  <xsl:template name="column.sep">
    <xsl:choose>
      <xsl:when test="(position() + 1) = last()">
	<xsl:value-of select="1"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:column-info" mode="colspec">
    <xsl:variable name="colsep" select="0"/>
<!--      <xsl:call-template name="column.sep"/>
    </xsl:variable> -->

    <xsl:variable name="colwidth">
      <xsl:call-template name="column.width"/>
    </xsl:variable>

    <xsl:variable name="align">
      <xsl:call-template name="column.alignment"/>
    </xsl:variable>

    <colspec colname="{@name}" colsep="{$colsep}" colwidth="{$colwidth}" align="{$align}"/>
  </xsl:template>

  <xsl:template match="lire:column-info" mode="spanspec">
    <xsl:if test="@col-start != @col-end">

      <xsl:variable name="start" select="@col-start"/>
      <xsl:variable name="end" select="@col-end"/>

      <xsl:variable name="namest" 
	select="ancestor::lire:table-info//lire:column-info[$start = @col-start]/@name"/>

      <xsl:variable name="nameend" 
	select="ancestor::lire:table-info//lire:column-info[$end = @col-start]/@name"/>

      <spanspec spanname="{@name}" namest="{$namest}" nameend="{$nameend}" align="left"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="lire:column-info" mode="thead">
    <xsl:variable name="label">
      <xsl:choose>
	<xsl:when test="@label">
	  <xsl:value-of select="@label"/>
	</xsl:when>
	<xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="@col-start != @col-end">
	<entry spanname="{@name}"><xsl:value-of select="$label"/></entry>
      </xsl:when>

      <xsl:otherwise>
	<entry colname="{@name}"><xsl:value-of select="$label"/></entry>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:table-info" mode="thead">
    <thead>
      <row>
	<!-- In the first table header row, we want the labels
	of the first row categorical column, and all the
	numerical columns' label -->
	<xsl:apply-templates select="lire:column-info[@class = 'categorical']"
	  mode="thead"/>
	<xsl:apply-templates select=".//lire:column-info[@class = 'numerical']"
	  mode="thead"/>
      </row>
      <xsl:call-template name="make.other.header.row"/>
    </thead>
  </xsl:template>

  <!-- The context-node should be the table-info element -->
  <xsl:template name="make.other.header.row">
    <xsl:param name="row-idx" select="1"/>

    <!-- Select the group-info element which are at this row index -->
    <xsl:variable name="group-infos"
      select=".//lire:group-info[@row-idx = $row-idx]"/>

    <xsl:if test="count($group-infos)">
      <row>
	<!-- We only process the categorical columns, the numerical 
	 ones are in the first row -->
	<xsl:apply-templates select="$group-infos/lire:column-info[@class = 'categorical']" mode="thead"/>
      </row>
      
      <!-- Try to make one more row -->
      <xsl:call-template name="make.other.header.row">
	<xsl:with-param name="row-idx" select="$row-idx + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="lire:table">
    <xsl:variable name="columns" 
      select="count(lire:table-info//lire:column-info)"/>

    <xsl:choose>
      <xsl:when test="lire:entry">
	<informaltable frame="all">
	  <tgroup cols="{$columns}" align="left" colsep="0" rowsep="0">
	    <xsl:apply-templates 
	      select="lire:table-info//lire:column-info" mode="colspec">
	      <xsl:sort data-type="number" select="@col-start"/>
	    </xsl:apply-templates>

	    <xsl:apply-templates select="lire:table-info//lire:column-info" mode="spanspec"/>

	    <xsl:apply-templates select="lire:table-info" mode="thead"/>

	    <tbody>
	      <xsl:call-template name="make.row"/>
	      <xsl:apply-templates select="lire:group-summary"/>
	    </tbody>
          </tgroup>
        </informaltable>
      </xsl:when>
      
      <xsl:otherwise><para>No content in report.</para></xsl:otherwise>

    </xsl:choose>
  </xsl:template>

  <!-- Write the table summary information on the last row of the table -->
  <xsl:template match="lire:table/lire:group-summary">
    <!-- We put the label in the first column -->
    <xsl:variable name="colinfo" 
      select="ancestor::lire:table/lire:table-info//lire:column-info[@col-start = 0]"/>

    <row>
      <xsl:choose>
	<xsl:when test="$colinfo/@col-start != $colinfo/@col-end">
	  <entry spanname="{$colinfo/@name}">Total for <xsl:value-of select="@nrecords"/> records </entry>
	</xsl:when>
	<xsl:otherwise>
	  <entry colname="{$colinfo/@name}">Total for <xsl:value-of select="@nrecords"/> records </entry>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="lire:value"/>
    </row>
  </xsl:template>

  <!-- The context node should be a lire:table element -->
  <xsl:template name="make.row">
    <xsl:param name="row-idx" select="0"/>

    <!-- Select the name and value element which are at this row index -->
    <xsl:variable name="entries"
      select=".//lire:entry[@row-idx = $row-idx]|.//lire:group-summary[@row-idx = $row-idx]"/>

    <xsl:if test="count($entries)">
      <row>
	<xsl:apply-templates select="$entries/lire:name|$entries/lire:value"/>
      </row>
      
      <!-- Try to make one more row -->
      <xsl:call-template name="make.row">
	<xsl:with-param name="row-idx" select="$row-idx + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="lire:name|lire:value">

    <!-- Find the column info associated with this one -->
    <xsl:variable name="colname" select="@col"/>
    <xsl:variable name="colinfo" 
      select="ancestor::lire:table/lire:table-info//lire:column-info[@name = $colname]"/>

    <xsl:choose>
      <xsl:when test="$colinfo/@col-start != $colinfo/@col-end">
	<entry spanname="{$colinfo/@name}"><xsl:value-of select="normalize-space(.)"/></entry>
      </xsl:when>
      <xsl:otherwise>
	<entry colname="{$colinfo/@name}"><xsl:value-of select="normalize-space(.)"/></entry>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:image">
    <mediaobject>
      <imageobject>
        <imagedata fileref="{lire:file}" format="{lire:file/@format}"/>
      </imageobject>
      <xsl:if test="lire:title">
	<caption>
	  <para><xsl:value-of select="lire:title"/></para>
	</caption>
      </xsl:if>
    </mediaobject>
  </xsl:template>

</xsl:stylesheet>

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
