package tests::functional::LrCheckServiceTest;

use base qw/Lire::Test::FunctionalTestCase/;

my @known_services = sort qw/
argomail bind8_query bind9_query bind8_named cisco_ios combined
common cups_pagelog dbmail exim ipchains ipfilter iptables
iis_ftp isdnlog lprng_account modgzip ms_isa mysql nms
nmsmmp nmsstore pgsql pix postfix qmail referer s1ms sendmail snort
spamassassin squid_access syslog tinydns w3c_extended watchguard welf
welf_proxy xferlog
/;
sub test_list_services {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_check_service -l" );
    $self->annotate( $result->stderr );
    $self->assert_equals( 0, $result->status );
    my @services = sort split ' ', $result->stdout;

    $self->assert_deep_equals( [ sort @known_services ], \@services );
}

sub test_existing_service {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_check_service squid_access" );
    $self->annotate( $result->stderr );
    $self->assert_equals( 0, $result->status );
    my $service = $result->stdout;
    chomp $service;
    $self->assert_equals( "squid_access", $service );
}

sub test_non_existing_service {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_check_service unknown_converter" );
    $self->annotate( $result->stderr );
    $self->assert_not_equals( 0, $result->status );
    $self->assert_equals( "", $result->stdout );
    $self->assert_matches( qr/isn't a known DLF converter/, $result->stderr );
}

sub test_usage {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_check_service" );
    $self->annotate( $result->stderr );
    $self->assert_not_equals( 0, $result->status );
    $self->assert_equals( "", $result->stdout );
    $self->assert_matches( qr/Usage: lr_check_service/, $result->stderr );
}

1;
