package tests::ReportParserReportBuilderTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::Report::TableInfo;
use Lire::Report;
use Lire::Report::Subreport;
use Lire::ReportParser::ReportBuilder;

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->{'parser'} = new Lire::ReportParser::ReportBuilder();
    $self->{'table_info'} = new Lire::Report::TableInfo();
    my $group = $self->{'table_info'}->create_group_info( 'group1' );
    $group->create_column_info( 'cell1', 'categorical', 'string' );

    my $report = new Lire::Report( 'test', 0, 1 );
    $self->{'subreport'} = new Lire::Report::Subreport( $report, 'test' );
    $self->{'subreport'}->table_info( $self->{'table_info'} );
    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    return $self;
}

sub test_entry_start {
    my $self = $_[0];

    $self->{'parser'}{'curr_subreport'} = $self->{'subreport'};
    push @{$self->{'parser'}{'group_stack'}}, $self->{'subreport'};
    $self->{'parser'}->entry_start( 'row-idx' => 0 );
    $self->assert_equals( 1, scalar @{$self->{'parser'}{'entry_stack'}} );
    $self->assert_equals( 0, $self->{'parser'}{'entry_stack'}[0]->row_idx() );

}

sub test_entry_start_compatibility {
    my $self = $_[0];

    $self->{'parser'}{'lrp_curr_table_info'} = $self->{'table_info'};
    push @{$self->{'parser'}{'group_stack'}}, $self->{'subreport'};
    $self->{'parser'}{'curr_subreport'} = $self->{'subreport'};
    $self->{'parser'}{'curr_subreport'}{'table_info'} = undef;
    $self->{'parser'}->entry_start();
    $self->assert_equals( $self->{'table_info'},
                          $self->{'subreport'}->table_info() );
    $self->assert_equals( 1, scalar @{$self->{'parser'}{'entry_stack'}} );
    $self->assert_null( $self->{'parser'}{'entry_stack'}[0]->row_idx() );
}

sub test_group_summary_start {
    my $self = $_[0];

    push @{$self->{'parser'}{'group_stack'}}, $self->{'subreport'};
    $self->{'parser'}->group_summary_start( 'nrecords' => 24,
                                            'missing-cases' => 1 );
    $self->assert_equals( 24, $self->{'subreport'}->nrecords() );
    $self->assert_equals( 1, $self->{'subreport'}->missing_cases() );
    $self->assert_null( $self->{'subreport'}->row_idx() );
    $self->{'parser'}->group_summary_start( 'nrecords' => 24,
                                            'missing-cases' => 1,
                                            'row-idx' => 0 );
    $self->assert_equals( 0, $self->{'subreport'}->row_idx() );
}

1;
