package tests::ConfigDlfSchemaSpecTest;

use strict;

use Carp;

use tests::ConfigSpecTest;

use base qw/tests::ConfigSelectSpecTest/;

use Lire::DlfSchema;

sub set_up {
    my $self = $_[0];

    $self->tests::ConfigScalarSpecTest::set_up();

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->tests::ConfigScalarSpecTest::tear_down();

    return;
}

sub my_superservices {
    return qw/ super1 super2 another_one /;
}

sub my_has_superservice {
    return ( $_[1] =~ /^super[12]$/ );
}

sub type {
    return "Lire::Config::DlfSchemaSpec";
}

sub value_type {
    return "Lire::Config::Scalar";
}

sub normalize_test_data {
    return (
            'super1' => "super1",
            'Super1' => undef,
           );
}

sub valid_test_data {
    return qw/ super1 super2 /;
}

sub invalid_test_data {
    return qw/ super4 /;
}

sub test_add {
    my $self = $_[0];

    $self->assert_died( sub { $self->{'spec'}->add() },
                        qr/Lire::Config::DlfSchemaSpec cannot contain any components/ );
}

sub test_normalize {
    my $self = $_[0];

    no warnings 'redefine';
    local *Lire::DlfSchema::has_superservice = \&my_has_superservice;

    $self->SUPER::test_normalize();
}

sub test_is_valid {
    my $self = $_[0];

    no warnings 'redefine';
    local *Lire::DlfSchema::has_superservice = \&my_has_superservice;

    $self->SUPER::test_is_valid();
}

sub test_options {
    my $self = $_[0];

    no warnings 'redefine';
    local *Lire::DlfSchema::superservices = \&my_superservices;

    my @options = $self->{'spec'}->options();

    $self->assert_num_equals( 3, scalar( @options ));
    $self->assert_isa( 'Lire::Config::OptionSpec', $options[0] );
    $self->assert_deep_equals( [ 'another_one', 'super1', 'super2' ],
                               [ map { $_->name() } @options ] );

}

1;
