package Lire::UI::StringWidget;

use strict;

use base qw/ Curses::UI::TextEntry Lire::UI::Widget /;

use Curses::UI::Common;
use Lire::Utils qw/ check_object_param /;

use Carp;
use vars qw/@CARP_NOT/;

@CARP_NOT = qw/Curses::UI::Container/;

sub new {
    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

    check_object_param( $userargs{'value'}, 'value',
                        'Lire::Config::Scalar' );

    my %args = (
                %userargs,
                '-sbborder' => 1,
                '-text' => $userargs{'value'}->get(),
                '-onchange' => \&_on_change_cb,
               );
    my $self =  $class->Curses::UI::TextEntry::new( %args );

    return $self;
}

sub refresh_view {
    my $self = $_[0];

    $self->text( $self->{'value'}->get() );

    return;
}

sub _on_change_cb {
    my $self = $_[0];

    $self->{'value'}->set( $self->{'-text'} );

    return;
}

1;
