package Lire::UI::BoolWidget;

use strict;

use base qw/ Curses::UI::Radiobuttonbox Lire::UI::Widget /;

use Carp;
use Curses::UI::Common;
use Locale::TextDomain 'lire';
use Lire::Utils qw/ check_object_param /;

use vars qw/@CARP_NOT/;

@CARP_NOT = qw/Curses::UI::Container/;

sub new {
    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

    check_object_param( $userargs{'value'}, 'value',
                        'Lire::Config::Scalar' );

    my %args = (
                '-height' => 2,
                %userargs,
                '-values' => [ __('yes'), __('no') ],
                '-onchange' => \&_on_change_cb,
               );
    my $self = $class->Curses::UI::Radiobuttonbox::new( %args );
    $self->refresh_view();

    return $self;
}

sub refresh_view {
    my $self = $_[0];

    # We don't want to use as_value() which will generate a
    # warning when the value is undef.
    my $bool = $self->{'value'}->spec()->normalize( $self->{'value'}->get() );
    $self->{'-selected'} = ( $bool ? 0 : 1 );

    $self->intellidraw();

    return;
}

sub _on_change_cb {
    my $self = $_[0];

    $self->{'value'}->set( ! $self->{'-selected'} );

    return;
}

1;
