package Lire::Min;

use strict;

use base qw/ Lire::SimpleStat /;

use Carp;

use Lire::Utils qw/ sql_quote_name /;

=pod

=head1 NAME

Lire::Min

=head1 SYNOPSIS

FIXME

=head1 DESCRIPTION

Class that implements the min operator. This operator will find the
minimum value appearing in a DLF field among a group of DLF records.

=head1 METHODS

=head2 new( %params )

Creates a new Lire::Min object.

=cut

sub new {
    my $self = bless {}, shift;

    $self->init( @_, 'op' => 'min' );

    return $self;
}

sub sql_aggr_expr {
    my $self = $_[0];

    return 'min(' . sql_quote_name( $self->{'field'} ) . ')';
}

# keep perl happy
1;

__END__

=head1 SEE ALSO

Lire::ReportSpec(3pm), Lire::ReportOperator(3pm), Lire::Aggregator(3pm), Lire::Aggregate(3pm).

=head1 VERSION

$Id: Min.pm,v 1.5 2004/03/26 00:27:34 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2001, 2002 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
