package Lire::DerivedSchema;

# vim:syntax=perl

use strict;

use base qw/ Lire::DlfSchema /;

use Lire::DataTypes qw( :special :xml );

use Carp;

sub new {
    my $proto = shift;
    my $class = ref( $proto) || $proto;

    my %attr = @_;

    croak "missing id attribute"
      unless exists $attr{'id'};
    croak "invalid id attribute: $attr{'id'}"
      unless check_xml_name( $attr{'id'} );

    my ( $super) =  $attr{'id'} =~ /^(\w+)-/
      or croak "cannot find superservice in id : %attr{'id'}";

    croak "invalid superservice in id: $super"
      unless check_superservice( $super );

    croak "missing base-schema attribute"
      unless exists $attr{'base-schema'};
    my $schema = Lire::DlfSchema::load_schema( $attr{'base-schema'} );
    croak "superservice of base schema doesn't match one in id: ",
      $schema->superservice, " != $super"
	if $schema->superservice ne $super;

    my $module = $attr{'module'}
      or croak "missing module attribute\n";

    my $self = $class->SUPER::new( 'timestamp'	=> $attr{'timestamp'},
				   'superservice' => $super,
				 );
    $self->{'id'}			= $attr{'id'};
    $self->{'base'}		= $schema;
    if ( exists $attr{'required-fields'} ) {
	$self->{'required_fields'} = [split /\s+/, $attr{'required-fields'}];
    } else {
	$self->{'required_fields'} = [];
    }
    foreach my $f ( @{$self->{'required_fields'}} ) {
	die "no required field $f in $attr{'base-schema'} base schema\n"
	  unless $schema->has_field( $f );
    }

    $self->{'module'} = $module;
    return $self;
}

sub base {
    return $_[0]->{'base'};
}

sub module {
    my $self = $_[0];

    my $module = $self->{'module'};
    eval "use $module;";
    croak "error loading $module module: $@\n" if $@;

    my $analyser = eval {
	no strict 'refs';
	$module->new( $self )
    };
    croak "error creating $module instance: $@" if $@;
    croak "$module module isn't of type Lire::DerivedSchema::DerivedRecordsCreator"
      unless UNIVERSAL::isa( $self->{'module'},
			     "Lire::DerivedSchema::DerivedRecordsCreator",
			   );
    return $analyser;
}

sub required_fields {
    return $_[0]->{'required_fields'};
}

# Interface implemented by module that can compute the
# records for a derived schema
package Lire::DerivedSchema::DerivedRecordsCreator;

sub new {
    my $proto = shift;
    my $class = ref( $proto) || $proto;

    return bless { 'schema' => $_[0] }, $class;
}

sub schema {
    return $_[0]->{'schema'};
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::DerivedSchema -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: DerivedSchema.pm,v 1.12 2004/03/26 00:27:34 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
