package Lire::Config::SelectSpec;

use strict;

=pod

=head1 Lire::Config::SelectSpec

Type that represents a choice. Values of this type can have one from a
set of possible choices.

The these values are normalized to the case specified in the options'
specification.

=cut

use base qw/Lire::Config::CompoundSpec/;

use Lire::Utils qw/ check_param check_object_param /;
use Lire::Config::Value;
use Carp;

=pod

=head2 options()

Returns as an array the valid options for this select.

=cut

sub options {
    return $_[0]->components();
}

sub instance {
    my $self = shift;
    return new Lire::Config::Scalar( @_, 'spec' => $self );
}

sub add {
    my ( $self, $option ) = @_;

    check_object_param( $option, 'option', 'Lire::Config::OptionSpec' );

    $self->SUPER::add( $option );

    return;
}

sub is_valid {
    my ( $self, $value ) = @_;

    return defined $self->normalize( $value );
}

sub normalize {
    my ( $self, $value ) = @_;

    return undef unless defined $value;

    foreach my $o ( $self->options() ) {
        return $o->name() if $o->is_option( $value );
    }

    return undef;
}

1;
__END__

=pod

=head1 VERSION

$Id: SelectSpec.pm,v 1.3 2004/03/24 11:18:18 wsourdeau Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
