package Lire::Config::PluginSpec;

use strict;

=pod

=head1 Lire::Config::PluginSpec

Type that represents a configuration variable which defines additional
properties based on the value which is currently selected. This can
be used for extensible type like DlfConverter or OutputFormat.

=cut

use base qw/Lire::Config::SelectSpec/;

use Lire::Config::Plugin;

sub instance {
    my $self = shift;
    return new Lire::Config::Plugin( @_, 'spec' => $self );
}

1;

__END__

=pod

=head1 VERSION

$Id: PluginSpec.pm,v 1.2 2004/03/17 21:45:08 wsourdeau Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
