/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MSettingsControl.h"

#include <wx/spinctrl.h>

const int BORDER_SIZE = 5;

CJT6MSettingsControl::CJT6MSettingsControl(wxWindow* parent, int id, int minLength) :
wxPanel(parent, id)
{
	wxStaticBoxSizer* sizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Min Settings")), wxVERTICAL);

	wxBoxSizer* syncSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* levelLabel = new wxStaticText(this, -1, wxT("Length\n(x10ms)"), wxDefaultPosition, wxSize(60, -1));
	syncSizer->Add(levelLabel, 0, wxTOP, BORDER_SIZE);

	wxSpinCtrl* level = new wxSpinCtrl(this, Spin_Minimum_Length, wxEmptyString, wxDefaultPosition, wxSize(40, -1));
	level->SetValue(minLength);
	level->SetRange(0, 100);
	syncSizer->Add(level, 0, wxALL, BORDER_SIZE);

	sizer->Add(syncSizer);

	wxStaticText* dummy = new wxStaticText(this, -1, wxEmptyString, wxDefaultPosition, wxSize(110, 30));
	sizer->Add(dummy);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CJT6MSettingsControl::~CJT6MSettingsControl()
{
}
