/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common/NCO.h"

#include "JT6MLookups.h"
#include "JT6MSend.h"
#include "JT6MDefs.h"

#include "jt6mgui/JT6MApp.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

CJT6MSend::CJT6MSend(CSoundDev* soundDev, CPTTPort* pttPort) :
CSend(soundDev, pttPort)
{
	wxASSERT(soundDev != NULL);
	wxASSERT(pttPort != NULL);
}

CJT6MSend::~CJT6MSend()
{
}

void CJT6MSend::run()
{
	::wxLogInfo(wxT("%ld: Starting JT6MSend"), GetId());

	// Make the message an even length
	wxString message = getMessage();
	if ((message.Length() % 2) == 1)
		message.Append(wxT(' '));

	CJT6MLookups lookups;
	CNCO nco(JT6M_SAMPLE_RATE);

	getPTTPort()->open();
	getPTTPort()->keyTX();

	getSoundDev()->openWrite();

	unsigned int charPos = 0;
	unsigned int syncPos = 0;

	while (!isStopped() && !getEndTime()) {
		int tone = lookups.lookupChar(message.GetChar(charPos));

		charPos = (charPos + 1) % message.Length();
		syncPos = (syncPos + 1) % 2;

		if (tone == -1)
			tone = lookups.lookupChar(wxT(' '));

		double freq, out[JT6M_SYMBOL_LENGTH];

		freq = double(tone + 50) * double(JT6M_SAMPLE_RATE) / double(JT6M_SYMBOL_LENGTH);
		nco.generate(freq, out, JT6M_SYMBOL_LENGTH);
		getSoundDev()->write(out, JT6M_SYMBOL_LENGTH, JT6M_SEND_VOLUME);

		if (syncPos == 1) {
			freq = double(50 * JT6M_SAMPLE_RATE) / double(JT6M_SYMBOL_LENGTH);
			nco.generate(freq, out, JT6M_SYMBOL_LENGTH);
			getSoundDev()->write(out, JT6M_SYMBOL_LENGTH, JT6M_SEND_VOLUME);
		}
	}

	getSoundDev()->close();

	getPTTPort()->unkeyTX();
	getPTTPort()->close();

	::wxLogInfo(wxT("%ld: JT6MSend ending"), GetId());
}

bool CJT6MSend::getEndTime() const
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 700);
}

void CJT6MSend::error(const wxString& text)
{
	::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
