/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MMessage_H
#define	JT6MMessage_H

#include <wx/wx.h>

class CJT6MMessage {

    public:
	CJT6MMessage(const wxString& id, double time, int length, int strength, int DF, int count, const wxString& text);
	virtual ~CJT6MMessage();

	virtual wxString getId() const;
	virtual double   getTime() const;
	virtual int      getLength() const;
	virtual int      getStrength() const;
	virtual int      getDF() const;
	virtual int      getCount() const;
	virtual wxString getText() const;

    private:
	wxString m_id;
	double   m_time;
	int      m_length;
	int      m_strength;
	int      m_df;
	int      m_count;
	wxString m_text;
};

WX_DECLARE_LIST(CJT6MMessage, CJT6MMessageList);

#endif
