/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Spectrum.h"

#include <wx/log.h>
#include <wx/debug.h>

CFSK441Spectrum::CFSK441Spectrum() :
m_spectrum()
{
}

CFSK441Spectrum::~CFSK441Spectrum()
{
}

void CFSK441Spectrum::addSpectrum(double v0, double v1, double v2, double v3)
{
	m_spectrum[0].addValue(v0);
	m_spectrum[1].addValue(v1);
	m_spectrum[2].addValue(v2);
	m_spectrum[3].addValue(v3);
}

double CFSK441Spectrum::getSpectrum(int n) const
{
	wxASSERT(n >= 0 && n < 4);

	return m_spectrum[n].getMaximum();
}
