/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FSK441Receive_H
#define	FSK441Receive_H

#include <wx/thread.h>

#include "common/Receive.h"
#include "common/Average.h"
#include "common/SoundDev.h"
#include "common/SoundFile.h"

#include "FSK441Levels.h"
#include "FSK441BurstData.h"
#include "FSK441Spectrum.h"
#include "FSK441Message.h"
#include "FSK441Defs.h"

class CFSK441Receive : public CReceive {

    public:
	CFSK441Receive();
	virtual ~CFSK441Receive();

	virtual void run();

	virtual void setSingleTone(bool singleTone);

	virtual void       openSoundDevice() = 0;
	virtual CSoundDev* getSoundDevice() = 0;
	virtual void       closeSoundDevice() = 0;

	virtual bool getEndTime() = 0;

	virtual void recordAudio(const wxString& id, double* audioData, int length) const = 0;
	virtual void showLevels(CFSK441Levels* levels) const = 0;
	virtual void showSpectrum(CFSK441Spectrum* spectrum) const = 0;
	virtual void receiveMessage(CFSK441Message* message) const = 0;

	virtual wxString createId() = 0;

    private:
	bool             m_singleTone;
	wxString         m_id;
	double*          m_audioSamples;
	CAverage         m_level;
	double*          m_levels[4];
	int              m_samplesCount;
	CAverage         m_noise;
	CFSK441BurstData m_burstData[FSK441_SYMBOL_LENGTH];
	CFSK441Spectrum* m_spectrum;

	bool correlate(double* v, double* c) const;
	int  seekBurst(int tim, double* v);
	int  storeBurst(int tim, double* v);
	void decodeBurst();
	void getLevels() const;
};

#endif
