/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wx/wx.h>

#include "common/Average.h"

#include "FSK441Levels.h"
#include "FSK441Defs.h"

CFSK441Levels::CFSK441Levels() :
m_audioData(NULL),
m_spectrumData(),
m_level(Audio_OK)
{
	m_audioData       = new double[FSK441_LEVEL_WIDTH];
	m_spectrumData[0] = new double[FSK441_LEVEL_WIDTH];
	m_spectrumData[1] = new double[FSK441_LEVEL_WIDTH];
	m_spectrumData[2] = new double[FSK441_LEVEL_WIDTH];
	m_spectrumData[3] = new double[FSK441_LEVEL_WIDTH];

	for (int i = 0; i < FSK441_LEVEL_WIDTH; i++) {
		m_audioData[i]       = 0.0;
		m_spectrumData[0][i] = 0.0;
		m_spectrumData[1][i] = 0.0;
		m_spectrumData[2][i] = 0.0;
		m_spectrumData[3][i] = 0.0;
	}
}

CFSK441Levels::~CFSK441Levels()
{
	delete[] m_audioData;
	delete[] m_spectrumData[0];
	delete[] m_spectrumData[1];
	delete[] m_spectrumData[2];
	delete[] m_spectrumData[3];
}

void CFSK441Levels::setAudioData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(FSK441_LEVEL_WIDTH) / double(FSK441_MAX_AUDIO_DATA);

	fillinData(data, count, scale, m_audioData);
}

void CFSK441Levels::setSpectrumData(int n, double* data, int count)
{
	wxASSERT(n >= 0 && n < 4);
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(FSK441_LEVEL_WIDTH) / double(count);

	fillinData(data, count, scale, m_spectrumData[n]);
}

void CFSK441Levels::setLevel(int level)
{
	m_level = level;
}

double CFSK441Levels::getAudioData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < FSK441_LEVEL_WIDTH);

	return m_audioData[pixel];
}

double CFSK441Levels::getSpectrumData(int n, int pixel) const
{
	wxASSERT(n >= 0 && n < 4);
	wxASSERT(pixel >= 0 && pixel < FSK441_LEVEL_WIDTH);

	return m_spectrumData[n][pixel];
}

int CFSK441Levels::getLevel() const
{
	return m_level;
}

void CFSK441Levels::fillinData(double* data, int count, double scale, double*& member)
{
	int lastPixel = 0;
	CAverage value;

	for (int i = 0; i < count; i++) {
		int pixel = int(scale * double(i));

		if (pixel == lastPixel) {
			value.addValue(data[i] * data[i]);
		} else {
			member[lastPixel] = value.getMaximum();
			value.clear();

			value.addValue(data[i] * data[i]);
			lastPixel = pixel;
		}
	}

	member[lastPixel] = value.getMaximum();
}
