/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	SoundDev_H
#define	SoundDev_H

#include <wx/string.h>

class CSoundDev {

    public:
    	CSoundDev();
	virtual ~CSoundDev();

	virtual void  openWrite(const wxString& fileName, int sampleRate, int sampleWidth) = 0;
	virtual void  openWrite() = 0;
	virtual void  openRead(const wxString& fileName, int sampleRate, int sampleWidth) = 0;
	virtual void  openRead() = 0;
	virtual bool  read(double* sample, int& len) = 0;
	virtual void  write(double* sample, int len, double volume) = 0;
	virtual void  close() = 0;

	static CSoundDev* createSoundDev(const wxString& type, const wxString& fileName = wxEmptyString, int sampleRate = 11025, int sampleWidth = 16);

    private:
};

#endif
