/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FFT.h"
#include "Exception.h"
#include "Inline.h"

#include <cmath>
using namespace std;

#include <wx/object.h>		// Not sure why !
#include <wx/debug.h>

CFFT::CFFT(int len) :
m_fftLen(len),
m_plan(NULL),
m_in(NULL),
m_out(NULL),
m_bins(NULL)
{
	wxASSERT(m_fftLen > 0);

	m_plan = ::fftw_create_plan(m_fftLen, FFTW_FORWARD, FFTW_ESTIMATE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM);

	if (m_plan == NULL)
		throw CException(wxT("Cannot create FFT plan"));

	m_in   = (fftw_complex*)::fftw_malloc(m_fftLen * sizeof(fftw_complex));
	m_out  = (fftw_complex*)::fftw_malloc(m_fftLen * sizeof(fftw_complex));

	if (m_in == NULL || m_out == NULL)
		throw CException(wxT("Cannot allocate FFT arrays"));

	m_bins = new double[m_fftLen];
}

CFFT::~CFFT()
{
	wxASSERT(m_plan != NULL);
	wxASSERT(m_in   != NULL);
	wxASSERT(m_out  != NULL);

	::fftw_destroy_plan(m_plan);

	::fftw_free(m_in);
	::fftw_free(m_out);

	delete[] m_bins;
}

double* CFFT::process(double* in)
{
	wxASSERT(m_plan != NULL);
	wxASSERT(m_in   != NULL);
	wxASSERT(m_out  != NULL);
	wxASSERT(in     != NULL);

	for (int i = 0; i < m_fftLen; i++) {
		c_re(m_in[i]) = in[i];
		c_im(m_in[i]) = 0.0;
	}

	::fftw_one(m_plan, m_in, m_out);

	for (int i = 0; i < m_fftLen; i++)
		m_bins[i] = ::CABS(c_re(m_out[i]), c_im(m_out[i]));

	return m_bins;
}
