/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "parameter.h"
#include "qsoinfo.h"
#include <qdatetime.h>

extern Parameter settings;
void QSOData::init()
{
QsoData= new QsoInfo();
*QsoData=*(settings.QsoData);
RemoteCallsign->setText(QsoData->TheirCall);
OPName->setText(QsoData->TheirName);
QTHName->setText(QsoData->QTH);
Loc->setText(QsoData->Locator);
QSOFrequency->setText(QsoData->Frequency);
HisRST->setText(QsoData->HisRst);
MineRST->setText(QsoData->MyRst);
QsoDate->setText(QsoData->QsoDate);
QSOTime->setText(QsoData->QsoTime);
}


void QSOData::clear()
{
if (QsoData != 0)
  delete QsoData;
QsoData= new QsoInfo();  
*(settings.QsoData)=*QsoData;
init();
}

void QSOData::Callsignchanged()
{
QsoData->TheirCall=RemoteCallsign->text();
settings.QsoData->TheirCall=QsoData->TheirCall;
}

void QSOData::Namechanged()
{
QsoData->TheirName=OPName->text();
settings.QsoData->TheirName=QsoData->TheirName;
}

void QSOData::QTHchanged()
{
QsoData->QTH=QTHName->text();
settings.QsoData->QTH=QsoData->QTH;

}

void QSOData::Locatorchanged()
{
QsoData->Locator=Loc->text();
settings.QsoData->Locator=QsoData->Locator;
}

void QSOData::Frequencychanged()
{
QsoData->Frequency=QSOFrequency->text();
settings.QsoData->Frequency=QsoData->Frequency;
}

void QSOData::HisRSTchanged()
{
QsoData->HisRst=HisRST->text();
settings.QsoData->HisRst=QsoData->HisRst;
}

void QSOData::MyRSTchanged()
{
QsoData->MyRst=MineRST->text();
settings.QsoData->MyRst=QsoData->MyRst;
}

void QSOData::Datechanged()
{
QsoData->QsoDate=QsoDate->text();
settings.QsoData->QsoDate=QsoData->QsoDate;
}

void QSOData::Timechanged()
{
QsoData->QsoTime=QSOTime->text();
settings.QsoData->QsoTime=QsoData->QsoTime;
}




void QSOData::refreshDateTime()
{
QDateTime t=QDateTime::currentDateTime();
t.addSecs(settings.timeoffset*3600);
QsoData->QsoDate=t.toString("d.MM.yyyy");
QsoData->QsoTime=t.toString("h:mm");
QsoDate->setText(QsoData->QsoDate);
QSOTime->setText(QsoData->QsoTime);
settings.QsoData->QsoTime=QsoData->QsoTime;
settings.QsoData->QsoDate=QsoData->QsoDate;
}
