/***************************************************************************
                          mfskdemodulator.cpp  -  description
                             -------------------
    begin                : Mit Jan 29 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatly, AE4JY             *
 ***************************************************************************/

#include "mfskdemodulator.h"
#include "deinterleaver.h"
#include "viterbi.h"
#include "constants.h"
#include "mfskvaricode.h"

const double MFSKDistance(double xa,int b)
{
unsigned int count,c;
int a;
a= (int) xa;
c = a ^ b;
count =0;
while( c > 0 )
  {
   if (c & 1) count++;
    c = c >>1;
  }
return double(count);

}

MFSKDemodulator::MFSKDemodulator():FSKDemodulator()
{
NumberofTones=16;
Baudrate=15.625;
phaseacc=0.;
pipeptr=0;

OszFrequency =0.;
Decoder=new MFSKVaricode();
viterbi = new Viterbi(7,0x6D,0x4F,MFSKDistance);
datashreg=0;
}
MFSKDemodulator::~MFSKDemodulator()
{
if ( leave != 0)
  delete leave;
if ( viterbi != 0)
  delete viterbi;
if ( bins != 0)
  delete bins;
if (twiddles != 0)
  delete twiddles;
if (history != 0)
  delete history;
if ( Pipe != 0)
  delete Pipe;
if ( Decoder !=0)
  delete Decoder;
if ( viterbi != 0)
  delete viterbi;
}

void MFSKDemodulator::ProcessInput(double * input)
{
int i;
complex<double> z;
OszFreqinc=(RxFrequency-1000.)*PI2/SampleRate;
//unsigned char  symbol[4],ch;
//int c;
for (i=0; i< NxSamples; i++)
  {


   z = Hilbert(input[i]);
//Generate complex sample by mixing input sample with NCO's sin/cos
  OszFrequency = OszFrequency + OszFreqinc ;
//**
  if(OszFrequency > PI2)		//handle 2 Pi wrap around
  OszFrequency -= PI2;
   else
    if ( OszFrequency < -PI2)
      OszFrequency += PI2;

  if(OszFrequency > M_PI)		//handle 2 Pi wrap around
  OszFrequency -= PI2;
   else
    if ( OszFrequency < -M_PI)
      OszFrequency += PI2;

  z = z * complex<double> (cos(OszFrequency),sin(OszFrequency));
  sfft(z);
  for (int j=0; j < NumberofTones;j++)
    Pipe[pipeptr][j]=bins[j];
  if (synccounter > 0)
    synccounter--;
     else
     if (symbolphase == symboltime)
     {
      synccounter = SymbolLength / 2;

      currsymbol = decodesymbol(bins);
      currvector = bins[currsymbol ];

      // decode symbol 
      recvsymbol( bins);

			// update the scope 
//			update_syncscope(m);

			// symbol sync 
			synchronize();

			// frequency tracking 
			afc();

			prev2symbol = prev1symbol;
			prev2vector = prev1vector;
			prev1symbol = currsymbol;
			prev1vector = currvector;
		}
      pipeptr = (pipeptr +1) % (2* SymbolLength);
      symbolphase = ( symbolphase + 1 ) % SymbolLength;


  }
}

int MFSKDemodulator::getSquelchValue()
{

return 0;
}
bool MFSKDemodulator::Init(double FS,int NumberofSamples)
{
SymbolLength=(int) (FS/Baudrate+0.5);
NxSamples=NumberofSamples;
SampleRate=FS;
OszFreqinc=(RxFrequency-1000.)*PI2/SampleRate;

//Pipe = new complex<double> [NumberofTones][2*SymbolLength];
//Pipe.reserve(2*NumberofTones*SymbolLength);
leave = new Deinterleaver[10]();
return init_sfft(SymbolLength);
}
bool MFSKDemodulator::init_sfft(int len)
{
#define	STABCOEFF	0.9999
if ( (bins=new complex<double>[NumberofTones]) == NULL)
  return false;
if ( (twiddles=new complex<double>[len]) == NULL)
  return false;
if ( (history=new complex<double>[len]) == NULL)
  return false;
for (int i = 0; i < len; i++) 
 twiddles[i] = complex<double>(cos(i * 2.0 * M_PI / len) * STABCOEFF,sin(i * 2.0 * M_PI / len) * STABCOEFF);
ptr=0;
return true;
}


void MFSKDemodulator::sfft(complex<double> input)
{
	complex<double> old, z;
	int i;
//  int first,last;
//  first =64; // Freq * SymbolLength / SampleRate = Freq / Baudrate
//  last = 80;

	/* restore the sample fftlen samples back */
	old = history[ptr];
//	old.re *= s->corr;
//	old.im *= s->corr;

	/* save the new sample */
  history[ptr] = input;

	/* advance the history pointer */
	ptr = (ptr + 1) % SymbolLength;

	/* calculate the wanted bins */
	for (i = 0; i < NumberofTones; i++)
 {
		z = bins[i];
		z = z - old;
		z = z + input;
		bins[i] = z * twiddles[i+64];
	}
}

int MFSKDemodulator::decodesymbol(complex<double> *in)
{
	int i, symbol = 0;
	double x, max = 0.0;


	for (i = 0; i < NumberofTones; i++) {
		if ((x = abs(in[i])) > max) {
			max = x;
			symbol = i;
		}
	}

	return symbol;
}
void MFSKDemodulator::recvsymbol(complex<double> *bins)
{
double tone, sum, b[4];
unsigned char symbols[4];
int i, j;

/* gray decode and form soft decision samples */
/**
	sum = b[0] = b[1] = b[2] = b[3] = 0.0;
	for (i = 0; i < 16; i++)
   {
		j = graydecode(i);

		tone = abs(bins[i]);

		b[0] += (j & 8) ? tone : -tone;
		b[1] += (j & 4) ? tone : -tone;
		b[2] += (j & 2) ? tone : -tone;
		b[3] += (j & 1) ? tone : -tone;

		sum += tone;
	}
**/
//	if (sum == 0.0) {
		/* avoid divide by zero */
/**
		symbols[0] = 0;
		symbols[1] = 0;
		symbols[2] = 0;
		symbols[3] = 0;
	} else {
**/
		/* shift to range 0...255 */
/**
		symbols[0] = clamp(128.0 + (b[0] / sum * 128.0));
		symbols[1] = clamp(128.0 + (b[1] / sum * 128.0));
		symbols[2] = clamp(128.0 + (b[2] / sum * 128.0));
		symbols[3] = clamp(128.0 + (b[3] / sum * 128.0));
	}
**/
/*******************Test ***********************/
j=graydecode(currsymbol);
for(i=3;i >=0 ; i--)
  {
    if (j & 1)
      symbols[i] ='1';
    else
      symbols[i] ='0';
    j = j >>1;
  }
/***************************/
  for(i=0; i < 10; i++)
    leave[i].deinterleave(symbols);
/********** Test *******/
j=0;
if ( symbols[0] == '1')
  j=2;
if (symbols[1] == '1')
  j = j+1;
viterbi->decode(j);
recvbit(viterbi->getbit(48));

j=0;
if ( symbols[2] == '1')
  j=2;
if (symbols[3] == '1')
  j = j+1;
viterbi->decode(j);
recvbit(viterbi->getbit(48));

/**
for(i=0; i <4; i++)
  {
    j=0;
    if ( symbols[i] == '1' )
      j = 1;
    recvbit(j);
  }
**/     
/*****************************/

//	viterbi->viterbi27( symbols);

//	if (viterbi->datalen > 0)
//   {

//		if (trx->squelchon && m->averagemetric < prefs.sqval)
//			return;
/**
		for (i = 0; i < viterbi->datalen; i++)
     {
			recvbit(viterbi->data[i] & 128);
			recvbit(viterbi->data[i] & 64);
			recvbit(viterbi->data[i] & 32);
			recvbit(viterbi->data[i] & 16);
			recvbit(viterbi->data[i] & 8);
			recvbit(viterbi->data[i] & 4);
			recvbit(viterbi->data[i] & 2);
			recvbit(viterbi->data[i] & 1);
		}
**/
//	}
/**/
}

void MFSKDemodulator::synchronize()
{
	int i, j, syn = -1;
	double val, max = 0.0;

	if (currsymbol == prev1symbol)
		return;
	if (prev1symbol == prev2symbol)
		return;

	for (i = 0;  ( unsigned int ) i < (2*SymbolLength); i++) {
		j = (i + pipeptr) % (2*SymbolLength);
		val = abs(Pipe[j][prev1symbol]);
		if (val > max) {
			syn = i;
			max = val;
		}
	}
i = SymbolLength;
//  syncaverage += (syn - SymbolLength) / 16.0;
  syncaverage += (syn - i) / 16.0;

	if (syncaverage < 0.0)
		syncaverage += SymbolLength;
	if (syncaverage >= SymbolLength)
		syncaverage -= SymbolLength;

	symboltime = (unsigned int) floor(syncaverage);
}

void MFSKDemodulator::afc()
{
complex<double> z;
double x;

	if (UseAfc == false)
		return;

	if (currsymbol !=prev1symbol)
		return;

	z = prev1vector* conj(currvector);
	x = atan2(z.imag(),z.real()) / SymbolLength / (2.0 * M_PI / SampleRate);

	if ( UseAfc && (x > - Baudrate / 2.0 ) &&   ( x < Baudrate / 2.0 ) )
      RxFrequency = RxFrequency + (x / 8.0);
}

void MFSKDemodulator::recvbit(int bit)
{
	int c;
  char zeichen;
	datashreg = (datashreg << 1);
  c = !! bit;
  datashreg = datashreg | c;

	/* search for "001" */
  c = datashreg & 7;
	if ((datashreg & 7) == 1)
   {
		/* the "1" belongs to the next symbol */
		c = Decoder->decode(datashreg >> 1);

///		if (c != -1)
///			trx_put_rx_char(c);
  zeichen = c;
  if ( c != -1 )
		emit newSymbol((char) c);
		/* we already received this */
		datashreg = 1;
	}
}
