/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void CTxDisplay::init()
{
calculateSizeofComponents();
TxFreq->setFunctionText("Net");
TxFreq->setTitle("Tx Freq");
}

void CTxDisplay::calculateSizeofComponents()
{
/** in percent of whole widget **/
/** TX Function part **/
#define TXFUNCTIONWIDTH 10
/** TxFrequency (Width) **/
#define TXFREQWIDTH 15
#define TXFREQHEIGHT 70
/** Left and Right Margin **/
#define LEFTANDRIGHTMARGIN 2
/** Top and Bottom Margin **/
#define TOPANDBOTTOMMARGIN 2
/** Inner distance **/
#define distance 3

int xpos,ypos,width,height,innerheight,innerwidth;
width=this->width();
height=this->height();
xpos=width*LEFTANDRIGHTMARGIN/100;

/** Frequency select Box **/

innerheight=height*TXFREQHEIGHT/100;
ypos=(height-innerheight)/2;
innerwidth=width*TXFREQWIDTH/100;

TxFreq->setGeometry(xpos,ypos,innerwidth,innerheight);

/** TX- Functions **/


ypos=height*TOPANDBOTTOMMARGIN/100;
innerheight=height-2*ypos;
xpos=xpos+innerwidth+width*distance/100;
innerwidth=width*TXFUNCTIONWIDTH/100;

TxFunctions->setGeometry(xpos,ypos,innerwidth,innerheight);
/** TX- Window **/
xpos=xpos+innerwidth+width*distance/100;
innerwidth=width-xpos-width*distance/100;
TxWindow->setGeometry(xpos,ypos,innerwidth,innerheight);

}

void CTxDisplay::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();

}
