/***************************************************************************
                          cspectrumdisplay.h  -  description
                             -------------------
    begin                : Son Dez 8 2002
    copyright            : (C) 2002 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatley, AE4JY            *              
 ***************************************************************************/

#ifndef CSPECTRUMDISPLAY_H
#define CSPECTRUMDISPLAY_H


#include <qobject.h>
#include <rfftw.h>
#include <qwidget.h>
#include <complex>
#include <qcolor.h>
#include <vector>

class QRadioButton;
class QSpinBox;
class QPixmap;
class CDisplay;
/**
  *@author Volker Schroer
  */

class CSpectrumDisplay : public QWidget  {
 Q_OBJECT
public: 
  CSpectrumDisplay( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~CSpectrumDisplay();
  void setInputPointer(double *);
  void setColorList(std::vector<QColor> *);


public slots:
  void startPlot();
  void setPhasePointer(std::complex<float> *);


protected:
    void resizeEvent( QResizeEvent * );

protected slots:
    virtual void languageChange();
  void setnewFrequency(int);
private:
    void calculateSizeofComponents();
    QSpinBox* MaxFreq;
    QSpinBox* MinFreq;

    CDisplay *Display;

  void plotspectrum();
/** Pointer to the Input for the FFT **/
  double *inputdata;
  std::complex<float> *Phase;
 void translate(void);
void paintLineal(QPainter* p,int y1,int y2);
void plotVector(QPainter *p);
  /** Results of FFT */

  void calcFFT();
  fftw_real* output;
  rfftw_plan plan;

  int fftdata[1024];    // Not all elements are used, it differs 
	int xtranslate[1024]; // depending on the display width
  double power_spectrum[1024];
// Pointer to the different Colors
std::vector<QColor> *Farbe;

QPixmap *pdisplay;   // Pixmap for Display for double buffering
QPixmap *pwaterfall; // Pixmap for Waterfall Display
bool overload;
signals:
void FrequencyChanged(double);
void new_IMD(float);

};

#endif
