/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#ifndef LINPSK_FOR_MAC
#include <sys/soundcard.h>
#endif
#include <qmessagebox.h>
#include <qwidget.h>
extern Parameter settings;

Parameter GeneralSettings::getSettings()
{
LocalSettings.callsign=Callsign->text();
if(Demomode->isOn() )
 {
   LocalSettings.DemoMode=true;
   LocalSettings.DemoTypeNumber=Fileformat->id(Fileformat->selected());
   LocalSettings.inputFilename="";
  }
else
  {
   LocalSettings.DemoMode=false;
   SoundDevice->setText(LocalSettings.SoundDevice);
  }
LocalSettings.timeoffset=UTC->value();
if( SlashedZero->isOn())
  LocalSettings.slashed0=true;
else
  LocalSettings.slashed0=false;

return LocalSettings;
}

void GeneralSettings::init()
{
connect(Output,SIGNAL(valueChanged(int)),this,SIGNAL(OutputLevelChanged(int)));
LocalSettings = settings;    
SoundDevice->setText(LocalSettings.SoundDevice);
Callsign->setText(LocalSettings.callsign);
UTC->setValue(LocalSettings.timeoffset);
SlashedZero->setChecked(LocalSettings.slashed0);

Demomode->setChecked(LocalSettings.DemoMode);

Fileformat->setButton(LocalSettings.DemoTypeNumber);
if (Demomode->isOn())
    Fileformat->show();
else
    Fileformat->hide();
PTT->setButton(LocalSettings.ptt);
//  PTTControl
    if(!checkcom("/dev/ttyS0"))
      COM1->hide();
    if(!checkcom("/dev/ttyS1"))
      COM2->hide();
    if(!checkcom("/dev/ttyS2"))
      COM3->hide();
    if(!checkcom("/dev/ttyS3"))
      COM4->hide();

if (LocalSettings.ptt < 5)
     SerialDevice->hide();
else
  {
   SerialDevice->setText(LocalSettings.SerialDevice);
   SerialDevice->show();
  }  
          
// Input Source (Ugly coding)
#ifndef LINPSK_FOR_MAC
	if (LocalSettings.InputSource == SOUND_MIXER_MIC)
	InputSelection->setButton(0);
		if (LocalSettings.InputSource == SOUND_MIXER_LINE)
	InputSelection->setButton(1);
Input->setValue(LocalSettings.InputVolume);
#else
InputSelection->hide();
ILevel->hide();
Input->hide();
         
#endif
Output->setValue(LocalSettings.OutputVolume);
}


void GeneralSettings::GeneralSettings_destroyed( QObject * )
{

}


void GeneralSettings::selectDemomode()
{
if (Demomode->isOn())
    Fileformat->show();
else
    Fileformat->hide();
}




void GeneralSettings::SelectInputSource( int Device )
{
#ifndef LINPSK_FOR_MAC
if (Device == 0 )
	LocalSettings.InputSource = SOUND_MIXER_MIC;
if (Device == 1 )
	LocalSettings.InputSource = SOUND_MIXER_LINE;
setVolume(LocalSettings.InputSource,LocalSettings.InputVolume);
#endif	
}

void GeneralSettings::setInputLevel( int Level )
{
#ifndef LINPSK_FOR_MAC
LocalSettings.InputVolume=Level;
setVolume(LocalSettings.InputSource,LocalSettings.InputVolume);
#endif 
}

void GeneralSettings::setOutputLevel( int Level )
{
LocalSettings.OutputVolume=Level; 
#ifndef LINPSK_FOR_MAC
setOutputVolume(LocalSettings.OutputVolume);
#endif    
}


void GeneralSettings::selectComPort( int port)
{
LocalSettings.ptt=port;
if (port == 5 )
   {
   SerialDevice->setText(LocalSettings.SerialDevice);
   SerialDevice->show();
  }
else
  { QString s;
    SerialDevice->hide();
     if (port > 0)
       LocalSettings.SerialDevice="/dev/ttyS"+s.setNum(port-1);     
  }

}


void GeneralSettings::setSerialDevice()
{
if (PTT->id(PTT->selected()) == 5 )
 {
  if (checkcom(SerialDevice->text()) )
    LocalSettings.SerialDevice=SerialDevice->text();
  else
      QMessageBox::warning( (QWidget *) 0,QString("Settings"),
        "Serial Device " + SerialDevice->text() + " not found \n Device remains unchanged",
        0);
  }
}


void GeneralSettings::setSoundDevice()
{
LocalSettings.SoundDevice=SoundDevice->text();
}
