   /*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ms.h"

#include "msrtpsend.h"
#include "msread.h"
#include "msavencoder.h"
#include "msnosync.h"
#include "msv4l.h"
#include "msqdispatcher.h"
#include "msvideooutput.h"

#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

static int cond=1;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

void stop_handler(int signum)
{
	cond=0;
}
#ifdef HAVE_AVCODEC

int main()
{
	MSFilter *play,*enc,*rec,*dis,*vo;
	MSSync *dummysync;	
	RtpSession *session;
	
	ms_init();
	ortp_init();
	ortp_set_debug_file("oRTP",NULL);
	ms_AVCodec_init();
	session=rtp_session_new(RTP_SESSION_RECVONLY);
	rtp_session_set_remote_addr(session,"127.0.0.1",8000);
	rtp_session_set_payload_type(session,32);	/*MPV*/
	rtp_session_set_blocking_mode(session,0);
	signal(SIGINT,stop_handler);
	
	play=ms_v4l_new();
	ms_v4l_set_device(MS_V4L(play),"/dev/video0");
	rec=ms_rtp_send_new();
	ms_rtp_send_set_session(MS_RTP_SEND(rec),session);
	enc=ms_mpeg_encoder_new();
	dis=ms_qdispatcher_new();
	vo=ms_video_output_new();
	dummysync=ms_nosync_new();

	ms_filter_add_link(play,dis);
	ms_filter_add_link(dis,enc);
	ms_filter_add_link(enc,rec);
	ms_filter_add_link(dis,vo);
	
	ms_sync_attach(dummysync,play);
	ms_video_output_set_size(MS_VIDEO_OUTPUT(vo),352,288);
	ms_start(dummysync);
	ms_AVencoder_set_format(MS_AVENCODER(enc),"RGB24");
	//ms_AVencoder_set_width(MS_AVENCODER(enc),320);
	//ms_AVencoder_set_height(MS_AVENCODER(enc),160);
	ms_v4l_start(MS_V4L(play));
	while(cond)
	{
		sleep(1);
	}
	ms_v4l_stop(MS_V4L(play));
	printf("stoping sync...\n");
	ms_stop(dummysync);
	printf("unlinking filters...\n");
	ms_filter_remove_links(play,dis);
	ms_filter_remove_links(dis,enc);
	ms_filter_remove_links(enc,rec);
	ms_filter_remove_links(dis,vo);
	printf("destroying filters...\n");
	ms_filter_destroy(play);
	ms_filter_destroy(enc);
	ms_filter_destroy(rec);
	ms_filter_destroy(vo);
	ms_filter_destroy(dis);
	return 0;
}
#else

int main()
{
	printf("AVcodec support is not compiled.\n");
	return 0;
}
#endif
