/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef RESOLVER_H
#define RESOLVER_H


#include "osipmanager.h"
#include <osip/dialog.h>
/*for later use */
/* the Resolver Cache Element*/
typedef struct _ResolverCacheEntry
{
	char *hostname;						/* for debugging */
	unsigned int ip4addr;
	unsigned int entry_date;   /* entry date in seconds. After a while, the cache entry should not be used */
	unsigned int access_cnt;   /* the access count */
} ResolverCacheEntry;

#define CACHE_ENTRY_DEFAULT_MAX_TIME 3600 /* seconds*/
#define RC_MAX_DEPHT 5

/* The ResolverCache */
typedef struct _ResolverCache
{
	int entry_cnt;
	int used_entry_cnt;
	int policy;
#define RC_DELETE_OLD
#define RC_DELETE_LESS_ACCESSED
	ResolverCacheEntry entries[1][RC_MAX_DEPHT];
} ResolverCache;
/* the ResolverCache oject is variable size. All cache entries can be accessed via ResolverCache::entries[k],
k=0...ResolverCache::entry_cnt .*/

ResolverCache * resolver_cache_new(unsigned int size);	

/* put host entity in cache */
void resolver_cache_put(ResolverCache *rc,char *hostname, unsigned int ip4addr);
/* try to get a host entity in cache. Returns0 if found, -1 elsewhere */
int resolver_cache_get(ResolverCache *rc,char *hostname, unsigned int *ip4addr);

/* set policy for removing cache entries*/
void resolver_cache_set_policy(ResolverCache *rc,int policy);

void resolver_cache_destroy(ResolverCache *rc);

/* private functions for the ResolverCache */
/* free line entries according to a rule, default is removing less used entries */
/* this function is used when the cache is full */
void resolver_cache_update(ResolverCache *rc);
/* the hash function */
unsigned int resolver_cache_hash(char *name);


typedef struct _async_resolv
{
	transaction_t *transaction;
	sipevent_t *event;
	char *dest;	/* for use for ack: DIRTY ACK, revisit later */
	int port;	/* for use for ack: DIRTY ACK, revisit later */
	sip_t *ackmsg;	/* for use for ack: DIRTY ACK, revisit later */
	dialog_t *dialog;
} async_resolv_t;


struct hostent *resolv(char *name);

void * resolver_thread(void *);

int async_resolv_and_send(OsipManager *manager, transaction_t *transaction, sipevent_t *sipevent);

int
async_resolv_and_send_ack (OsipManager * manager, dialog_t *dialog, char *dest, int port,
			   sip_t * ackmsg);
#endif

