/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "osipua.h"
#include "osipmanager.h"
#include "resolver.h"
#include "utils.h"
#include "uatransaction.h"


void nist_kill_transaction(transaction_t * trn)
{
	osip_trace (OSIP_INFO1,("Transaction %i killed.\n", trn->transactionid));
	ua_transaction_free (trn);
}

void nist_register_received(transaction_t * trn, sip_t *sipmsg)
{
	int error;
	OsipDialog *dia;
	osip_trace (OSIP_INFO1,("nist_register_received: not fully implemented"));
	
	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	/* always answer Not implemented */
	if (dia!=NULL){
	  //ua_transaction_incoming_set_dialog (trn, dia);
	  //osip_dialog_update_from_request(dia,sipmsg);
	}else {
		/* should answer not implemented ? */
	}
}


void nist_bye_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *call;
	OsipUA *ua;
	int error;
	osip_trace (OSIP_INFO1, ("nist_bye_received():\n"));

	error = osip_dialog_find (sipmsg,&call);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_nist(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (call != NULL)
	{
		/* an existing call-leg was found, so process it */
		ua = osip_dialog_get_ua (call);
		ua_transaction_set_incoming_bye_tr(trn, call);
		/* indicate the user of the end of the call-leg */
		if (ua->bye != NULL)
			ua->bye (call, trn, sipmsg,
				 (void *) NULL);
		/* respond 200 OK to the client */
		osip_dialog_respond (call, trn, 200);
		/* then delete the call */
		osip_dialog_release (call);
	}
	else
	{
		osip_trace (OSIP_WARNING,
				("Bye for an inexistant dialog !\n"));
		ua = (OsipUA *) list_get (&ua_list, 0);
		respond_to_request (ua->config, trn, 481);
		/* return an Inexistant Call-Leg */
	}
	return;		/* ok */
}


void nist_cancel_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *dia;
	OsipUA *ua;
	int error;

	osip_trace (OSIP_INFO1, ("nist_cancel_received():"));

	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (dia!=NULL){
	  //osip_dialog_update_from_request(dia,sipmsg);
		/* an existing call-leg was found, so process it */
		ua = osip_dialog_get_ua (dia);
		ua_transaction_set_incoming_cancel_tr(trn, dia);
		osip_dialog_set_state(dia,DIALOG_CANCELLED);
		/* cancel the previous invite transaction */
		//ua_transaction_free(dia->inc_invite_tr);
		/* indicate the user of the end of the call-leg */
		if (ua->bye != NULL)
			ua->bye (dia, trn, sipmsg,
				 (void *) NULL);
		osip_dialog_respond(dia,trn,200);
		/* respond 487 to the client */
		if (dia->inc_invite_tr!=NULL)
			osip_dialog_respond (dia, dia->inc_invite_tr, 487);
		else osip_trace(OSIP_WARNING,("null invite request!\n"));
		/* then delete the call */
		osip_dialog_release (dia);
	}else {
		/* should answer not implemented ? */
	}	
}

void nist_options_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *dia;
	OsipUA *ua;
	int error;

	osip_trace (OSIP_WARNING, ("nist_options_received(): not fully implemented.\n"));

	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (dia!=NULL){
 	  /* TODO */

	  //ua_transaction_incoming_set_dialog (trn, dia);
	  //osip_dialog_update_from_request(dia,sipmsg);
		/* answer 200 OK ? */
	  //osip_dialog_respond(dia,trn,200);
	}else {
		/* should answer not implemented ? */
	}	
}

