/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "osipua.h"
#include "utils.h"
#include "osipmanager.h"
#include <osip/port.h>
#include <osip/sdp.h>

#include <osip/global.h>
#include <osip/md5.h>

#include "digcalc.h"

void CvtHex(
	    IN HASH Bin,
	    OUT HASHHEX Hex
	    )
{
  unsigned short i;
  unsigned char j;
  
  for (i = 0; i < HASHLEN; i++) {
    j = (Bin[i] >> 4) & 0xf;
    if (j <= 9)
      Hex[i*2] = (j + '0');
    else
      Hex[i*2] = (j + 'a' - 10);
    j = Bin[i] & 0xf;
    if (j <= 9)
      Hex[i*2+1] = (j + '0');
    else
      Hex[i*2+1] = (j + 'a' - 10);
  };
  Hex[HASHHEXLEN] = '\0';
};

/* calculate H(A1) as per spec */
void DigestCalcHA1(
		   IN char * pszAlg,
		   IN char * pszUserName,
		   IN char * pszRealm,
		   IN char * pszPassword,
		   IN char * pszNonce,
		   IN char * pszCNonce,
		   OUT HASHHEX SessionKey
		   )
{
  MD5_CTX Md5Ctx;
  HASH HA1;
  
  MD5Init(&Md5Ctx);
  MD5Update(&Md5Ctx, pszUserName, strlen(pszUserName));
  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, pszRealm, strlen(pszRealm));
  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, pszPassword, strlen(pszPassword));
  MD5Final(HA1, &Md5Ctx);
  if ((pszAlg!=NULL)&&strcasecmp(pszAlg, "md5-sess") == 0) {
    MD5Init(&Md5Ctx);
    MD5Update(&Md5Ctx, HA1, HASHLEN);
    MD5Update(&Md5Ctx, ":", 1);
    MD5Update(&Md5Ctx, pszNonce, strlen(pszNonce));
    MD5Update(&Md5Ctx, ":", 1);
    MD5Update(&Md5Ctx, pszCNonce, strlen(pszCNonce));
    MD5Final(HA1, &Md5Ctx);
  };
  CvtHex(HA1, SessionKey);
};

/* calculate request-digest/response-digest as per HTTP Digest spec */
void DigestCalcResponse(
			IN HASHHEX HA1,         /* H(A1) */
			IN char * pszNonce,     /* nonce from server */
			IN char * pszNonceCount,  /* 8 hex digits */
			IN char * pszCNonce,    /* client nonce */
			IN char * pszQop,       /* qop-value: "", "auth", "auth-int" */
			IN char * pszMethod,    /* method from the request */
			IN char * pszDigestUri, /* requested URL */
			IN HASHHEX HEntity,     /* H(entity body) if qop="auth-int" */
			OUT HASHHEX Response    /* request-digest or response-digest */
			)
{
  MD5_CTX Md5Ctx;
  HASH HA2;
  HASH RespHash;
  HASHHEX HA2Hex;
  
  // calculate H(A2)
  MD5Init(&Md5Ctx);
  MD5Update(&Md5Ctx, pszMethod, strlen(pszMethod));
  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, pszDigestUri, strlen(pszDigestUri));
  
  if (pszQop!=NULL)
    {
      char *index = strchr(pszQop,'i');

/*#define AUTH_INT_SUPPORT*/            /* experimental  */
#ifdef AUTH_INT_SUPPORT                   /* experimental  */
      while (index!=NULL&&index-pszQop>=5&&strlen(index)>=3)
	{
	  if (strncasecmp(index-5, "auth-int",8) == 0)
	    {
	      goto auth_withqop;
	    }
	  index = strchr(index+1,'i');
	}

      strchr(pszQop,'a');
      while (index!=NULL&&strlen(index)>=4)
	{
	  if (strncasecmp(index-5, "auth",4) == 0)
	    {
	      /* and in the case of a unknown token
		 like auth1. It is not auth, but this
		 implementation will think it is!??
		 This is may not happen but it's a bug!
	      */
	      goto auth_withqop;
	    }
	  index = strchr(index+1,'a');
	}
#endif
      goto auth_withoutqop;

  };
  
 auth_withoutqop:
  MD5Final(HA2, &Md5Ctx);
  CvtHex(HA2, HA2Hex);

  // calculate response
  MD5Init(&Md5Ctx);
  MD5Update(&Md5Ctx, HA1, HASHHEXLEN);
  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, pszNonce, strlen(pszNonce));
  MD5Update(&Md5Ctx, ":", 1);

  goto end;

 auth_withqop:

  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, HEntity, HASHHEXLEN);
  MD5Final(HA2, &Md5Ctx);
  CvtHex(HA2, HA2Hex);

  // calculate response
  MD5Init(&Md5Ctx);
  MD5Update(&Md5Ctx, HA1, HASHHEXLEN);
  MD5Update(&Md5Ctx, ":", 1);
  MD5Update(&Md5Ctx, pszNonce, strlen(pszNonce));
  MD5Update(&Md5Ctx, ":", 1);
    MD5Update(&Md5Ctx, pszNonceCount, strlen(pszNonceCount));
    MD5Update(&Md5Ctx, ":", 1);
    MD5Update(&Md5Ctx, pszCNonce, strlen(pszCNonce));
    MD5Update(&Md5Ctx, ":", 1);
    MD5Update(&Md5Ctx, pszQop, strlen(pszQop));
    MD5Update(&Md5Ctx, ":", 1);

 end:
  MD5Update(&Md5Ctx, HA2Hex, HASHHEXLEN);
  MD5Final(RespHash, &Md5Ctx);
  CvtHex(RespHash, Response);
};


int
osip_create_authorization_header(sip_t *previous_answer,
				 char *rquri, char *username, char *passwd,
				 authorization_t **auth)
{
  authorization_t *aut;
  www_authenticate_t *wa=NULL;

	msg_getwww_authenticate(previous_answer,0,&wa);
 

  /* make some test */
  if (wa==NULL||wa->auth_type==NULL
      ||(wa->realm==NULL)||(wa->nonce==NULL)) {
    osip_trace(OSIP_INFO1,("www_authenticate header is not acceptable.\n"));
    return -1;
    }
  if (0!=strcasecmp("Digest",wa->auth_type)) {
    osip_trace(OSIP_INFO1,("Authentication method not supported. (Digest only).\n"));
      return -1;
    }
  if (wa->algorithm!=NULL&&0!=strcasecmp("MD5",wa->algorithm)) {
    osip_trace(OSIP_INFO1,("Authentication method not supported. (Digest only).\n"));
      return -1;
    }
  if (0!=authorization_init(&aut)) {
    osip_trace(OSIP_INFO1,("allocation with authorization_init failed.\n"));
    return -1;
  }

  /* just copy some feilds from response to new request */
  authorization_setauth_type(aut,sgetcopy("Digest"));
  authorization_setrealm(aut,sgetcopy(www_authenticate_getrealm(wa)));
  authorization_setnonce(aut,sgetcopy(www_authenticate_getnonce(wa)));
  if (www_authenticate_getopaque(wa)!=NULL)
    authorization_setopaque(aut,sgetcopy(www_authenticate_getopaque(wa)));
  /* copy the username field in new request */
  aut->username = smalloc(strlen(username)+3);
  sprintf(aut->username,"\"%s\"",username);

  /* DON'T KNOW WHAT TO PUT IN THIS FEILD!!!!!!  (Aymeric) */
  /* TO BE CHECKED!! */
  {
    char *tmp = smalloc(strlen(rquri)+3);
    sprintf(tmp,"\"%s\"",rquri);
    authorization_seturi(aut,tmp);
  }
    authorization_setalgorithm(aut,sgetcopy("MD5"));
  
  {   
    char * pszNonce = sgetcopy_unquoted_string(www_authenticate_getnonce(wa));
    char * pszCNonce= NULL ; 
    char * pszUser = username;
    char * pszRealm = sgetcopy_unquoted_string(authorization_getrealm(aut));
    char * pszPass=NULL;
    char * pszAlg = sgetcopy("MD5");
    char *szNonceCount = NULL;
    char * pszMethod = previous_answer->cseq->method;
    char * pszQop = NULL;
    char * pszURI = rquri;    

    HASHHEX HA1;
    HASHHEX HA2 = "";
    HASHHEX Response;

	if (passwd!=NULL){
		pszPass=passwd;
	}else
    {
    	osip_trace(OSIP_INFO1,("Unable to get a password: no registration context."));
		return -1;
    }
    /*printf("*************************call_leg->reg_context=%x, password=%x\n",
    		call_leg->reg_context,call_leg->reg_context->password);*/
    if (authorization_getnonce_count(aut)!=NULL)
      szNonceCount = sgetcopy(authorization_getnonce_count(aut));
    if (authorization_getmessage_qop(aut)!=NULL)
      pszQop = sgetcopy(authorization_getmessage_qop(aut));

    DigestCalcHA1(pszAlg, pszUser, pszRealm, pszPass, pszNonce,
	 	  pszCNonce, HA1);
    DigestCalcResponse(HA1, pszNonce, szNonceCount, pszCNonce, pszQop,
		       pszMethod, pszURI, HA2, Response);
    osip_trace(OSIP_INFO1,("Response in authorization |%s|\n", Response));
    {
      char *resp = smalloc(35);
      sprintf(resp,"\"%s\"",Response);
      authorization_setresponse(aut,resp);
    }
  }

  *auth = aut;
  return 0;
}


int
osip_create_proxy_authorization_header(sip_t *previous_answer,
				       char *rquri, char *username, char *passwd,
				       proxy_authorization_t **auth)
{
  proxy_authorization_t *aut=NULL;
  proxy_authenticate_t *wa=NULL;
	char *p;

	msg_getproxy_authenticate(previous_answer,0,&wa);
  
  /* make some test */
  if (wa==NULL||wa->auth_type==NULL
      ||(wa->realm==NULL)||(wa->nonce==NULL)) {
    osip_trace(OSIP_INFO1,("www_authenticate header is not acceptable.\n"));
      return -1;
    }
  if (0!=strcasecmp("Digest",wa->auth_type)) {
    osip_trace(OSIP_INFO1,("Authentication method not supported. (Digest only).\n"));
      return -1;
    }
  if (wa->algorithm!=NULL&&0!=strcasecmp("MD5",wa->algorithm)) {
    osip_trace(OSIP_INFO1,("Authentication method not supported. (MD5 Digest only).\n"));
      return -1;
    }
  if (0!=proxy_authorization_init(&aut)) {
    osip_trace(OSIP_INFO1,("allocation with authorization_init failed.\n"));
    return -1;
  }

  /* just copy some feilds from response to new request */
  proxy_authorization_setauth_type(aut,sgetcopy("Digest"));
  proxy_authorization_setrealm(aut,sgetcopy(proxy_authenticate_getrealm(wa)));
  proxy_authorization_setnonce(aut,sgetcopy(proxy_authenticate_getnonce(wa)));
  if (proxy_authenticate_getopaque(wa)!=NULL)
    proxy_authorization_setopaque(aut,sgetcopy(proxy_authenticate_getopaque(wa)));
  /* copy the username field in new request */
  aut->username = smalloc(strlen(username)+3);
  sprintf(aut->username,"\"%s\"",username);

  /* DON'T KNOW WHAT TO PUT IN THIS FEILD!!!!!!  (Aymeric) */
  /* TO BE CHECKED!! */
  {
    char *tmp = smalloc(strlen(rquri)+3);
    sprintf(tmp,"\"%s\"",rquri);
    proxy_authorization_seturi(aut,tmp);
  }
    proxy_authorization_setalgorithm(aut,sgetcopy("MD5"));
  
  {
    char * pszNonce = NULL;
    char * pszCNonce= NULL ; 
    char * pszUser = username;
    char * pszRealm = sgetcopy_unquoted_string(proxy_authorization_getrealm(aut));
    char * pszPass = NULL;
    char * pszAlg = sgetcopy("MD5");
    char *szNonceCount = NULL;
    char * pszMethod = previous_answer->cseq->method;
    char * pszQop = NULL;
    char * pszURI = rquri; 
   
    HASHHEX HA1;
    HASHHEX HA2 = "";
    HASHHEX Response;
    
	if (passwd!=NULL){
		pszPass=passwd;
	}else 
    {
    	osip_trace(OSIP_INFO1,("Unable to get a password: no registration context."));
		return -1;
    }
	
    if (www_authenticate_getnonce(wa)==NULL){
	  osip_trace(OSIP_INFO1,("No nonce..."));
      return -1;
	}
    pszNonce = sgetcopy_unquoted_string(www_authenticate_getnonce(wa));

    /* should upgrade szNonceCount */
    /* should add szNonceCount in aut*/
    /* should upgrade pszCNonce */
    /* should add pszCNonce in aut */
    
    if (proxy_authenticate_getqop_options(wa)!=NULL)
      {
	szNonceCount = sgetcopy("00000001");
	/* MUST be incremented on each */
	pszQop = sgetcopy(proxy_authenticate_getqop_options(wa));
	pszCNonce = sgetcopy("234abcc436e2667097e7fe6eia53e8dd");
      }
    DigestCalcHA1(pszAlg, pszUser, pszRealm, pszPass, pszNonce,
	 	  pszCNonce, HA1);
    DigestCalcResponse(HA1, pszNonce, szNonceCount, pszCNonce, pszQop,
		       pszMethod, pszURI, HA2, Response);
    osip_trace(OSIP_INFO1,("Response in proxy_authorization |%s|\n", Response));
    {
      char *resp = smalloc(35);
      sprintf(resp,"\"%s\"",Response);
      proxy_authorization_setresponse(aut,resp);
    }
  }
  /*proxy_authorization_2char(aut,&p);
  osip_trace(OSIP_INFO1,("proxy authorization header; %s \n",p));*/
  *auth = aut;
  return 0;
}
