/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ms.h"
#include "msfilter.h"
#include "msv4l.h"
#include "msvideooutput.h"
#include "msread.h"
#include "mstimer.h"
#include "msnosync.h"
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>

int cond=1;

void stop_handler(int signum)
{
	cond=0;
}


int main(int argc, char*argv[])
{
	MSFilter *source,*vo;
	MSSync *timer;
	gint width,height;
	
	if (argc<2) {
		printf("test_gdkvo name  (filename or device name)\n");
		return 0;
	}
	
	ms_init();
	
	signal(SIGINT,stop_handler);
	source=ms_v4l_new();
	ms_v4l_set_device(MS_V4L(source),argv[1]);
	//source=ms_read_new(argv[1]);
	vo=ms_video_output_new();
	
	ms_video_output_set_title(MS_VIDEO_OUTPUT(vo),"local image");
	ms_filter_add_link(source,vo);
	
	timer=ms_nosync_new();
	//ms_timer_set_interval(MS_TIMER(timer),100);
	
	ms_sync_attach(timer,source);
	
	ms_v4l_start(MS_V4L(source));
	ms_start(timer);
	while (cond) sleep(1);
	ms_v4l_stop(MS_V4L(source));
	ms_stop(timer);
	ms_sync_detach(timer,source);
	ms_filter_remove_links(source,vo);
	ms_filter_destroy(source);
	ms_filter_destroy(vo);
	ms_sync_destroy(timer);
	g_message("End of test program.");
	return 0;
}
